import { ref } from 'vue';

const sessionList = ref([]);
const sessionId = ref('');

function addSession(id) {
    if (!sessionList.value.includes(id)) {
        sessionList.value.unshift(id);
    }
    sessionId.value = id;
}

function setSessionId(id) {
    sessionId.value = id;
}

export default function useSessionStore() {
    return {
        sessionList,
        sessionId,
        addSession,
        setSessionId,
    };
}
