/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.proxy;

import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import oracle.jdbc.proxy.HashUtil;

class GeneratedProxiesRegistry {
    private Map<Key, Value> registry = Collections.synchronizedMap(new HashMap());

    GeneratedProxiesRegistry() {
    }

    void put(Class clazz, Class clazz2, Value value) {
        this.registry.put(new Key(clazz, clazz2), value);
    }

    Value get(Class clazz, Class clazz2) {
        return this.registry.get(new Key(clazz, clazz2));
    }

    int size() {
        return this.registry.size();
    }

    Set<Key> keySet() {
        return this.registry.keySet();
    }

    Collection<Value> values() {
        return this.registry.values();
    }

    static class Value {
        private final String name;
        private final String source;
        private final Class clazz;
        private final Constructor constructor;

        Value(String string, String string2, Class clazz, Constructor constructor) {
            this.name = string;
            this.source = string2;
            this.clazz = clazz;
            this.constructor = constructor;
        }

        String getName() {
            return this.name;
        }

        String getSource() {
            return this.source;
        }

        Class getClazz() {
            return this.clazz;
        }

        Constructor getConstructor() {
            return this.constructor;
        }
    }

    static class Key {
        private final String PREFIX = "oracle.jdbc.proxy.";
        private final String SUFFIX = "$$$Proxy";
        private final Class iface;
        private final Class superclass;
        private Integer hashCode = null;

        Key(Class clazz, Class clazz2) {
            this.iface = clazz;
            this.superclass = clazz2;
        }

        Key(String string) {
            this.iface = this.parseIface(string);
            this.superclass = this.parseSuperclass(string);
        }

        public boolean equals(Object object) {
            if (null == object) {
                return false;
            }
            try {
                Key key = (Key)object;
                return this.iface.equals(key.iface) && this.superclass.equals(key.superclass);
            }
            catch (ClassCastException classCastException) {
                return false;
            }
        }

        public int hashCode() {
            if (null == this.hashCode) {
                this.hashCode = 23;
                this.hashCode = HashUtil.hash((int)this.hashCode, this.iface);
                this.hashCode = HashUtil.hash((int)this.hashCode, this.superclass);
            }
            return this.hashCode;
        }

        public String toString() {
            return "oracle.jdbc.proxy." + this.superclass.getName().replace(".", "$1") + "$2" + this.iface.getName().replace(".", "$1") + "$$$Proxy";
        }

        private Class parseSuperclass(String string) {
            try {
                String string2 = string.substring("oracle.jdbc.proxy.".length());
                String string3 = string2.replaceAll("\\$1", ".");
                String string4 = string3.substring(0, string3.indexOf("$2"));
                return Class.forName(string4);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new RuntimeException(classNotFoundException);
            }
        }

        private Class parseIface(String string) {
            try {
                String string2 = string.substring("oracle.jdbc.proxy.".length());
                String string3 = string2.replaceAll("\\$1", ".");
                String string4 = string3.substring(string3.indexOf("$2") + 2, string3.indexOf("$$$Proxy"));
                return Class.forName(string4);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new RuntimeException(classNotFoundException);
            }
        }

        public Class getIface() {
            return this.iface;
        }

        public Class getSuperclass() {
            return this.superclass;
        }

        public String makePathname() {
            return this.toString().replace(".", "/") + ".class";
        }
    }
}

