import com.baomidou.mybatisplus.core.toolkit.StringPool;
import com.baomidou.mybatisplus.generator.AutoGenerator;
import com.baomidou.mybatisplus.generator.InjectionConfig;
import com.baomidou.mybatisplus.generator.config.*;
import com.baomidou.mybatisplus.generator.config.po.TableInfo;
import com.baomidou.mybatisplus.generator.config.rules.NamingStrategy;
import com.baomidou.mybatisplus.generator.engine.FreemarkerTemplateEngine;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

class CodeGenerator {
    public static void main(String[] args) {
        AutoGenerator generator = new AutoGenerator();

        GlobalConfig gc = new GlobalConfig();
        String projectPath = System.getProperty("user.dir");
        //输出文件路径
        gc.setOutputDir(projectPath + "/src/main/java");
        //TODO 改动
        gc.setAuthor("XGL");
        gc.setOpen(false);
        gc.setFileOverride(true);
        gc.setActiveRecord(false);
        // XML 二级缓存
        gc.setEnableCache(false);
        // XML ResultMap
        gc.setBaseResultMap(true);
        // XML columList
        gc.setBaseColumnList(true);
        //生成的service接口名字首字母是否为I，这样设置就没有I
        gc.setServiceName("I%sService");
        //实体属性 Swagger2 注解
        gc.setSwagger2(true);
        generator.setGlobalConfig(gc);

        // 数据源配置 TODO 改动
        DataSourceConfig dataSourceConfig = new DataSourceConfig();
        dataSourceConfig.setUrl("jdbc:oracle:thin:@10.10.31.139:1521:orcl");
        dataSourceConfig.setDriverName("oracle.jdbc.driver.OracleDriver");
        dataSourceConfig.setUsername("HIIP");
        dataSourceConfig.setPassword("123456");
        generator.setDataSource(dataSourceConfig);

        // 包配置
        PackageConfig pc = new PackageConfig();
        //TODO 改动
        //pc.setModuleName("base");
        //TODO 改动
        pc.setParent("com.fxkc.hiip");
        pc.setController("controller");
        pc.setService("service");
        pc.setServiceImpl("service.impl");
        pc.setMapper("dao");
        pc.setEntity("entity");
        generator.setPackageInfo(pc);

        //生成mapper.xml
        InjectionConfig injectionConfig = new InjectionConfig() {
            @Override
            public void initMap() {
                // to do nothing
            }
        };
        String mapperTemplatePath = "/templates/mapper.xml.ftl";
        // 自定义输出配置
        List<FileOutConfig> fileOutConfigList = new ArrayList<>();
        // 自定义配置会被优先输出
        fileOutConfigList.add(new FileOutConfig(mapperTemplatePath) {
            @Override
            public String outputFile(TableInfo tableInfo) {
                //TODO 改动
               // return projectPath + "/src/main/resources/mapper/" + pc.getModuleName() + "/" + tableInfo.getEntityName() + "Mapper" + StringPool.DOT_XML;
                return projectPath + "/src/main/resources/mapper/" + tableInfo.getEntityName() + "Mapper" + StringPool.DOT_XML;
            }
        });
        injectionConfig.setFileOutConfigList(fileOutConfigList);
        generator.setCfg(injectionConfig);

        // 配置自定义本地模板
        TemplateConfig templateConfig = new TemplateConfig();
        templateConfig.setController("templates/my.controller.java");
        templateConfig.setService("templates/my.service.java");
        templateConfig.setServiceImpl("templates/my.serviceImpl.java");
        templateConfig.setMapper("templates/my.mapper.java");
        templateConfig.setEntity("templates/my.entity.java");
        templateConfig.setXml(null);
        generator.setTemplate(templateConfig);

        // 策略配置
        StrategyConfig strategy = new StrategyConfig();
        //下划线到驼峰的命名方式
        strategy.setNaming(NamingStrategy.underline_to_camel);
        //下划线到驼峰的命名方式
        strategy.setColumnNaming(NamingStrategy.underline_to_camel);
        //是否使用lombok
        strategy.setEntityLombokModel(true);
        //是否使用RestController
        strategy.setRestControllerStyle(true);

        //TODO 指定目标表
        strategy.setInclude(new String[]{"USER_INFO"});
        //true:@RequestMapping使用controllerMappingHyphen，例如：USER_INFO表为user-info
        //false:@RequestMapping使用entityPath，例如：USER_INFO表为userInfo
        strategy.setControllerMappingHyphenStyle(false);
        //strategy.setTablePrefix(pc.getModuleName() + "_");
        generator.setStrategy(strategy);
        generator.setTemplateEngine(new FreemarkerTemplateEngine());
        generator.execute();
    }
}
