"""
@Project ：chatwoot-agent 
@File    ：event_processor.py
@Author  ：Lijun
@Date    ：2025/8/20 9:26 
"""
from handler import ConversationResolvedHandler, MessageCreatedEventHandler, NothingEventHandler, Event


class EventProcessor:

    def __init__(self):
        self.processors = [
            MessageCreatedEventHandler(),
            ConversationResolvedHandler(),
            NothingEventHandler()
        ]

    def process(self, event: Event):
        for processor in self.processors:
            if processor.support(event):
                return processor.handle_event(event)
        raise ValueError(f"没有找到支持事件类型 {event.event_type}的处理器")
