package org.liquibase.core.configuration;

import liquibase.changelog.visitor.ChangeExecListener;
import org.liquibase.core.liquibase.LiquibaseCreator;
import org.liquibase.core.property.DynamicProperty;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import javax.sql.DataSource;
import java.util.List;


@Configuration
@EnableConfigurationProperties(DynamicLiquibaseProperties.class)
@ConditionalOnProperty(prefix = DynamicLiquibaseProperties.PREFIX, name = "enabled", havingValue = "true", matchIfMissing = true)
public class DynamicLiquibaseConfiguration {

    public static final String SPRING_LIQUIBASE = "SpringLiquibase";

    private final ConfigurableListableBeanFactory beanFactory;
    private final DynamicLiquibaseProperties properties;
    private final List<ChangeExecListener> listeners;
    private final List<DynamicProperty<?>> dynamicProperties;
    private final DataSource dataSource;

    public DynamicLiquibaseConfiguration(ConfigurableListableBeanFactory beanFactory,
                                         DynamicLiquibaseProperties properties,
                                         List<ChangeExecListener> listeners,
                                         List<DynamicProperty<?>> dynamicProperties,
                                         DataSource dataSource) {
        this.beanFactory = beanFactory;
        this.properties = properties;
        this.listeners = listeners;
        this.dynamicProperties = dynamicProperties;
        this.dataSource = dataSource;
    }

    @Bean
    public LiquibaseCreator liquibaseCreator() {
        return new LiquibaseCreator(beanFactory, properties, listeners, dynamicProperties, dataSource);
    }
}
