package com.smart.hospital.common.im.callback.group;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import com.smart.hospital.common.im.callback.AbstractCallbackCommand;
import com.smart.hospital.common.im.msg.AbstractMsgBody;

import java.util.List;

/**
 * 群内发言之后回调
 *
 * @author guer
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class GroupAfterSendMsgCallbackCommand extends AbstractCallbackCommand {

    /**
     * 产生群消息的群组 ID
     */
    @JsonProperty("GroupId")
    private String groupId;

    /**
     * 产生群消息的 群组形态介绍，例如 Private，Public 和 ChatRoom
     */
    @JsonProperty("Type")
    private String type;

    /**
     * 消息发送者 Identifier
     */
    @JsonProperty("From_Account")
    private String fromAccount;

    /**
     * 请求的发起者
     */
    @JsonProperty("Operator_Account")
    private String operatorAccount;

    /**
     * 随机数
     */
    @JsonProperty("Random")
    private Integer random;

    /**
     * 消息序列号，用于标记该条消息
     */
    @JsonProperty("MsgSeq")
    private Integer msgSeq;

    /**
     * 消息发送的时间戳，对应后台 Server 时间
     */
    @JsonProperty("MsgTime")
    private Integer msgTime;

    /**
     * 消息体
     */
    @JsonProperty("MsgBody")
    private List<AbstractMsgBody<?>> msgBody;
}
