package com.smart.hospital.common.lock.advisor;

import com.smart.hospital.common.lock.advisor.pointcut.DistributedLockPointcut;
import com.smart.hospital.common.lock.advisor.source.LockAttributeSource;
import org.aopalliance.aop.Advice;
import org.springframework.aop.Pointcut;
import org.springframework.aop.support.AbstractPointcutAdvisor;
import org.springframework.lang.Nullable;

/**
 * 分布式锁Advisor
 */
public class DistributedLockAdvisor extends AbstractPointcutAdvisor {

	private transient volatile Object adviceMonitor = new Object();

	@Nullable
	private transient volatile Advice advice;

	private LockAttributeSource lockAttributeSource;

	private final DistributedLockPointcut pointcut = new DistributedLockPointcut() {
		@Override
		protected LockAttributeSource getLockAttributeSource() {
			return lockAttributeSource;
		}
	};

	@Override
	public Pointcut getPointcut() {
		return this.pointcut;
	}

	@Override
	public Advice getAdvice() {
		Advice advice = this.advice;
		if (advice != null) {
			return advice;
		}
		return null;
	}

	public void setAdvice(Advice advice) {
		synchronized (this.adviceMonitor) {
			this.advice = advice;
		}
	}

	public void setLockAttributeSource(LockAttributeSource lockAttributeSource) {
		this.lockAttributeSource = lockAttributeSource;
	}


}
