package com.smart.hospital.common.lock.advisor.attribute;

import com.smart.hospital.common.lock.enums.LockType;

import java.util.concurrent.TimeUnit;

/**
 * 锁属性
 */
public interface LockAttribute {

	/**
	 * 获取锁类型
	 *
	 * @return
	 */
	LockType getLockType();

	/**
	 * 加锁时间，超过该时长自动解锁，默认单位为：秒
	 *
	 * @return
	 */
	long getLeaseTime();

	/**
	 * 等待锁时间，默认单位：秒
	 *
	 * @return
	 */
	long getWaitTime();

	/**
	 * 锁时长单位
	 *
	 * @return
	 */
	TimeUnit getTimeUnit();
}
