package com.smart.hospital.common.lock.advisor.parser;

import com.smart.hospital.common.lock.advisor.attribute.DistributedLockAttribute;
import com.smart.hospital.common.lock.advisor.attribute.LockAttribute;
import com.smart.hospital.common.lock.enums.LockType;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.annotation.AnnotationUtils;

import java.lang.annotation.Annotation;
import java.util.concurrent.TimeUnit;

/**
 * 分布式锁注解解析类
 */
public class DistributedLockAnnotationParser extends AbstractLockAnnotationParser {


	@Override
	protected LockAttribute parseLockAnnotation(AnnotationAttributes attributes) {
		DistributedLockAttribute attr = new DistributedLockAttribute();

		// 锁类型
		if (attributes.containsKey("lockType")) {
			LockType lockType = attributes.getEnum("lockType");
			attr.setLockType(lockType);
		}

		// 加锁时间
		if (attributes.containsKey("leaseTime")) {
			attr.setLeaseTime(attributes.getNumber("leaseTime"));
		}

		// 等待时间
		if (attributes.containsKey("waitTime")) {
			attr.setWaitTime(attributes.getNumber("waitTime"));
		}

		// 时间单位
		if (attributes.containsKey("timeUnit")) {
			TimeUnit timeUnit = attributes.getEnum("timeUnit");
			attr.setTimeUnit(timeUnit);
		}

		return attr;
	}

	@Override
	protected LockAttribute parseLockAnnotation(Annotation annotation) {
		return parseLockAnnotation(AnnotationUtils.getAnnotationAttributes(annotation, false, false));
	}
}
