package com.smart.hospital.common.lock.advisor.pointcut;

import com.smart.hospital.common.lock.advisor.source.LockAttributeSource;
import org.springframework.aop.ClassFilter;
import org.springframework.aop.MethodMatcher;
import org.springframework.aop.Pointcut;

import java.lang.reflect.Method;

public abstract class DistributedLockPointcut implements MethodMatcher, Pointcut {

	private ClassFilter classFilter = ClassFilter.TRUE;

	@Override
	public boolean matches(Method method, Class<?> targetClass) {
		LockAttributeSource tas = getLockAttributeSource();
		return (tas == null || tas.getLockAttribute(method, targetClass) != null);
	}

	@Override
	public boolean isRuntime() {
		return false;
	}

	@Override
	public boolean matches(Method method, Class<?> targetClass, Object... args) {
		// should never be invoked because isRuntime() returns false
		throw new UnsupportedOperationException("Illegal MethodMatcher usage");
	}

	@Override
	public ClassFilter getClassFilter() {
		return this.classFilter;
	}

	public void setClassFilter(ClassFilter classFilter) {
		this.classFilter = classFilter;
	}

	@Override
	public MethodMatcher getMethodMatcher() {
		return this;
	}

	protected abstract LockAttributeSource getLockAttributeSource();

}
