package com.smart.hospital.common.lock.annotation;


import com.smart.hospital.common.lock.enums.LockType;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.concurrent.TimeUnit;

/**
 * zookeeper分布式锁的注解
 */
@Retention(value = RetentionPolicy.RUNTIME)
@Target(value = {ElementType.METHOD})
public @interface ZLock {

	/**
	 * 锁类型
	 *
	 * @return
	 */
	LockType lockType() default LockType.MUTEX;

	/**
	 * 等待锁时间，默认单位：秒
	 *
	 * @return
	 */
	long waitTime() default 1;

	/**
	 * 锁时长单位
	 *
	 * @return
	 */
	TimeUnit timeUnit() default TimeUnit.SECONDS;
}
