package com.smart.hospital.common.lock.config;

import com.smart.hospital.common.lock.enums.ZkRetryPolicy;

import java.util.HashMap;
import java.util.Map;

public class ZkRetryPolicyStore {

	private static Map<String, ZkRetryPolicy> retryPolicyMap = new HashMap<>();

	static {
		retryPolicyMap.put(ZkRetryPolicy.RETRY_EXPONENTIAL_BACKOFF.getPolicyName(), ZkRetryPolicy.RETRY_EXPONENTIAL_BACKOFF);
		retryPolicyMap.put(ZkRetryPolicy.RETRY_FOREVER.getPolicyName(), ZkRetryPolicy.RETRY_FOREVER);
		retryPolicyMap.put(ZkRetryPolicy.RETRY_NTIMES.getPolicyName(), ZkRetryPolicy.RETRY_NTIMES);
		retryPolicyMap.put(ZkRetryPolicy.RETRY_UNTIL_ELAPSED.getPolicyName(), ZkRetryPolicy.RETRY_UNTIL_ELAPSED);
	}

	/**
	 * 根据字符串策略名，返回策略
	 *
	 * @param policyName
	 * @return
	 */
	public static ZkRetryPolicy getPolicy(String policyName) throws IllegalAccessException {
		ZkRetryPolicy zkRetryPolicy = retryPolicyMap.get(policyName);
		if (zkRetryPolicy == null) {
			throw new IllegalAccessException("没有找到相应的策略,请检测参数是否正常,policyName的值为:" + policyName);
		}
		return zkRetryPolicy;
	}
}
