package com.smart.hospital.common.lock.config;

import com.smart.hospital.common.lock.config.zookeeper.ExponentialBackoffRetryConfig;
import com.smart.hospital.common.lock.config.zookeeper.ForeverRetryConfig;
import com.smart.hospital.common.lock.config.zookeeper.NTimesRetryConfig;
import com.smart.hospital.common.lock.config.zookeeper.UntilElapsedRetryConfig;
import com.smart.hospital.common.lock.enums.ZkRetryPolicy;

/**
 * zookeeper配置类
 */
public class ZookeeperSchemeConfig {

	private String address;

	private int sessionTimeout;

	private int connectionTimeoutMs;

	private String retryPolicy = ZkRetryPolicy.RETRY_EXPONENTIAL_BACKOFF.getPolicyName();

	/**
	 * 重试直到最大重试时长为止策略
	 */
	private UntilElapsedRetryConfig untilElapsedRetry;

	/**
	 * 重试间隔休眠时间指数递增策略
	 */
	private ExponentialBackoffRetryConfig exponentialBackoffRetry = new ExponentialBackoffRetryConfig();

	/**
	 * 一直重试，直到成功
	 */
	private ForeverRetryConfig foreverRetry;

	/**
	 * 重试多次,提供一个构造函数，传入重试次数参数
	 */
	private NTimesRetryConfig ntimesRetry;

	public String getAddress() {
		return address;
	}

	public void setAddress(String address) {
		this.address = address;
	}

	public int getSessionTimeout() {
		return sessionTimeout;
	}

	public void setSessionTimeout(int sessionTimeout) {
		this.sessionTimeout = sessionTimeout;
	}

	public int getConnectionTimeoutMs() {
		return connectionTimeoutMs;
	}

	public void setConnectionTimeoutMs(int connectionTimeoutMs) {
		this.connectionTimeoutMs = connectionTimeoutMs;
	}

	public String getRetryPolicy() {
		return retryPolicy;
	}

	public void setRetryPolicy(String retryPolicy) {
		this.retryPolicy = retryPolicy;
	}

	public UntilElapsedRetryConfig getUntilElapsedRetry() {
		return untilElapsedRetry;
	}

	public void setUntilElapsedRetry(UntilElapsedRetryConfig untilElapsedRetry) {
		this.untilElapsedRetry = untilElapsedRetry;
	}

	public ExponentialBackoffRetryConfig getExponentialBackoffRetry() {
		return exponentialBackoffRetry;
	}

	public void setExponentialBackoffRetry(ExponentialBackoffRetryConfig exponentialBackoffRetry) {
		this.exponentialBackoffRetry = exponentialBackoffRetry;
	}

	public ForeverRetryConfig getForeverRetry() {
		return foreverRetry;
	}

	public void setForeverRetry(ForeverRetryConfig foreverRetry) {
		this.foreverRetry = foreverRetry;
	}

	public NTimesRetryConfig getNtimesRetry() {
		return ntimesRetry;
	}

	public void setNtimesRetry(NTimesRetryConfig ntimesRetry) {
		this.ntimesRetry = ntimesRetry;
	}
}
