package com.smart.hospital.common.lock.key;

import com.smart.hospital.common.lock.enums.LockScheme;
import com.smart.hospital.common.lock.enums.LockType;

import java.util.List;
import java.util.concurrent.TimeUnit;

public class RedisLockKey implements LockKey<String, List<String>> {

	private long leaseTime = -1;

	private long waitTime = -1;

	private TimeUnit timeUnit = TimeUnit.SECONDS;

	private LockScheme lockScheme;

	private LockType lockType;

	/**
	 * key列表
	 */
	private List<String> keyList;

	public RedisLockKey(LockType lockType, LockScheme lockScheme, long leaseTime, long waitTime, TimeUnit timeUnit, List<String> keyList) {
		this.lockType = lockType;
		this.lockScheme = lockScheme;
		this.leaseTime = leaseTime;
		this.waitTime = waitTime;
		this.timeUnit = timeUnit;
		this.keyList = keyList;
	}

	@Override
	public long getLeaseTime() {
		return leaseTime;
	}

	@Override
	public long getWaitTime() {
		return waitTime;
	}

	@Override
	public TimeUnit getTimeUnit() {
		return timeUnit;
	}

	@Override
	public List<String> getKey() {
		return this.keyList;
	}

	@Override
	public void setKey(String key) {
		this.keyList.add(key);
	}

	@Override
	public LockScheme getLockScheme() {
		return this.lockScheme;
	}

	@Override
	public LockType getLockType() {
		return this.lockType;
	}

	@Override
	public String toString() {
		return "RedisLockKey{" +
				"leaseTime=" + leaseTime +
				", waitTime=" + waitTime +
				", timeUnit=" + timeUnit +
				", lockScheme=" + lockScheme +
				", lockType=" + lockType +
				", keyList=" + keyList +
				'}';
	}
}
