package com.smart.hospital.common.lock.service;

import com.smart.hospital.common.lock.key.LockKey;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;

import java.util.List;

public abstract class AbstractRedisLockService implements LockService {

	protected LockKey<String, List<String>> lockKey;

	protected RedissonClient client;

	private RLock lock;

	public AbstractRedisLockService(LockKey<String, List<String>> lockKey, RedissonClient client) {
		this.lockKey = lockKey;
		this.client = client;
	}

	@Override
	public void lock() throws Exception {
		this.lock = this.client.getFairLock(this.lockKey.getKey().get(0));

		if (this.lockKey.getLeaseTime() == -1 && this.lockKey.getWaitTime() == -1) {
			lock.lock();
			return;
		}
		if (this.lockKey.getLeaseTime() != -1 && this.lockKey.getWaitTime() == -1) {
			this.lock.lock(this.lockKey.getLeaseTime(), this.lockKey.getTimeUnit());
			return;
		}
		if (this.lockKey.getLeaseTime() != -1 && this.lockKey.getWaitTime() != -1) {
			boolean isLock = this.lock.tryLock(this.lockKey.getWaitTime(), this.lockKey.getLeaseTime(), this.lockKey.getTimeUnit());
			if (!isLock) {
				throw new IllegalStateException("加锁失败");
			}
			return;
		}

		this.lock.lock();
	}

	@Override
	public void release() {
		this.lock.forceUnlock();
	}
}
