package com.smart.hospital.common.lock.service.provider;

import com.smart.hospital.common.lock.enums.LockScheme;
import com.smart.hospital.common.lock.enums.LockType;
import com.smart.hospital.common.lock.key.LockKey;
import com.smart.hospital.common.lock.service.LockService;
import org.apache.curator.framework.CuratorFramework;
import org.redisson.api.RedissonClient;

import java.util.List;

public interface LockServiceProvider {

	/**
	 * 获取锁
	 *
	 * @return
	 */
	LockService getLockService(CuratorFramework zkClient, RedissonClient client, LockKey<String, List<String>> lockKey);

	/**
	 * 是否支持
	 *
	 * @param scheme
	 * @param lockType
	 * @return
	 */
	boolean supports(LockScheme scheme, LockType lockType);
}
