package com.smart.hospital.common.lock.service.provider.redis;

import com.smart.hospital.common.lock.enums.LockScheme;
import com.smart.hospital.common.lock.enums.LockType;
import com.smart.hospital.common.lock.key.LockKey;
import com.smart.hospital.common.lock.service.LockService;
import com.smart.hospital.common.lock.service.impl.redis.RedisFairRedisLockService;
import com.smart.hospital.common.lock.service.provider.LockServiceProvider;
import org.apache.curator.framework.CuratorFramework;
import org.redisson.api.RedissonClient;

import java.util.List;

public class RedisFairLockServiceProvider implements LockServiceProvider {

	@Override
	public LockService getLockService(CuratorFramework zkClient, RedissonClient client, LockKey<String, List<String>> lockKey) {
		return new RedisFairRedisLockService(lockKey, client);
	}

	@Override
	public boolean supports(LockScheme scheme, LockType lockType) {
		return LockScheme.REDIS == scheme && LockType.FAIR == lockType;
	}
}
