package com.smart.hospital.common.mq;

import com.smart.hospital.common.mq.config.RabbitMqConfiguration;
import com.smart.hospital.common.mq.factory.RabbitClientRegister;
import com.smart.hospital.common.mq.handler.ConfirmCallbackHandler;
import com.smart.hospital.common.mq.handler.MessageContentHandler;
import com.smart.hospital.common.mq.handler.ReturnCallbackHandler;
import com.smart.hospital.common.mq.handler.confirm.DefaultConfirmCallbackHandler;
import com.smart.hospital.common.mq.handler.holder.DefaultMessageContentHandler;
import com.smart.hospital.common.mq.handler.returns.DefaultReturnCallbackHandler;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;


@Configuration
public class MqAutoConfiguration {

	@Bean(initMethod = "init")
	public RabbitMqConfiguration rabbitMqConfiguration(RabbitTemplate rabbitTemplate,
													   ConfirmCallbackHandler confirmCallbackHandler,
													   ReturnCallbackHandler returnCallbackHandler) {
		return new RabbitMqConfiguration(rabbitTemplate, confirmCallbackHandler, returnCallbackHandler);
	}

	@Bean
	public RabbitClientRegister rabbitClientRegister(MessageContentHandler messageContentHandler) {
		RabbitClientRegister register = new RabbitClientRegister();
		register.setRabbitTemplateBeanName("rabbitTemplate");
		register.setMessageContentHandler(messageContentHandler);
		register.setBasePackage("com.smart.hospital.common.mq.client");
		return register;
	}

	@Bean
	@ConditionalOnMissingBean
	public MessageContentHandler messageContentHandler() {
		return new DefaultMessageContentHandler();
	}

	@Bean
	@ConditionalOnMissingBean
	public ConfirmCallbackHandler confirmCallbackHandler(MessageContentHandler messageContentHandler) {
		return new DefaultConfirmCallbackHandler(messageContentHandler);
	}

	@Bean
	@ConditionalOnMissingBean
	public ReturnCallbackHandler returnCallbackHandler(MessageContentHandler messageContentHandler) {
		return new DefaultReturnCallbackHandler(messageContentHandler);
	}

}
