package com.smart.hospital.common.mq.domin;

import org.springframework.amqp.core.Message;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 默认的消息内容
 */
public class DefaultMessage implements Serializable {

	/**
	 * 消息体
	 */
	private Object msg;

	/**
	 * 交换机
	 */
	private String exchange;

	/**
	 * 路由键
	 */
	private String routingKey;

	/**
	 * 消息投递状态
	 */
	private Integer deliverStatus;

	/**
	 * 消息的创建按时间
	 */
	private LocalDateTime sendTime = LocalDateTime.now();

	public DefaultMessage(Object msg, String exchange, String routingKey, Integer deliverStatus) {
		this.msg = msg;
		this.exchange = exchange;
		this.routingKey = routingKey;
		this.deliverStatus = deliverStatus;
	}

	public Object getMsg() {
		return msg;
	}

	public void setMsg(Object msg) {
		this.msg = msg;
	}

	public String getExchange() {
		return exchange;
	}

	public void setExchange(String exchange) {
		this.exchange = exchange;
	}

	public String getRoutingKey() {
		return routingKey;
	}

	public void setRoutingKey(String routingKey) {
		this.routingKey = routingKey;
	}

	public Integer getDeliverStatus() {
		return deliverStatus;
	}

	public void setDeliverStatus(Integer deliverStatus) {
		this.deliverStatus = deliverStatus;
	}

	public LocalDateTime getSendTime() {
		return sendTime;
	}

	public void setSendTime(LocalDateTime sendTime) {
		this.sendTime = sendTime;
	}

	@Override
	public String toString() {
		return "DefaultMessage{" +
				"msg=" + msg +
				", exchange='" + exchange + '\'' +
				", routingKey='" + routingKey + '\'' +
				", deliverStatus=" + deliverStatus +
				", sendTime=" + sendTime +
				'}';
	}
}
