package com.smart.hospital.common.mq.enums;

/**
 * 消息投递状态
 */
public enum DeliverStatus {

	DELIVERING(0, "消息投递中"),

	DELIVER_SUCCESS(1, "投递成功"),

	DELIVER_EXCHANGE_FAIL(2, "消息投递到Exchange失败"),

	DELIVER_QUEUE_FAIL(3, "消息从Exchange投递到Queue失败"),

	CONSUMED_SUCCESS(4, "已消费");

	/**
	 * 投递状态码
	 */
	private Integer code;

	/**
	 * 投递状态消息
	 */
	private String msg;

	DeliverStatus(Integer code, String msg) {
		this.code = code;
		this.msg = msg;
	}

	public Integer getCode() {
		return code;
	}

	public void setCode(Integer code) {
		this.code = code;
	}

	public String getMsg() {
		return msg;
	}

	public void setMsg(String msg) {
		this.msg = msg;
	}
}
