package com.smart.hospital.common.mq.factory;

import com.smart.hospital.common.mq.handler.MessageContentHandler;
import org.springframework.amqp.rabbit.core.RabbitTemplate;

import java.lang.reflect.Proxy;

public class ClientProxyFactory<T> {

	private final Class<T> clientInterface;

	public ClientProxyFactory(Class<T> clientInterface) {
		this.clientInterface = clientInterface;
	}

	public Class<T> getClientInterface() {
		return clientInterface;
	}

	@SuppressWarnings("unchecked")
	protected T newInstance(ClientProxy<T> mapperProxy) {
		return (T) Proxy.newProxyInstance(clientInterface.getClassLoader(), new Class[]{clientInterface}, mapperProxy);
	}

	@SuppressWarnings("unchecked")
	public T newInstance(RabbitTemplate rabbitTemplate, MessageContentHandler messageContentHandler) {
		ClientProxy<T> proxy = new ClientProxy<>(rabbitTemplate, clientInterface, messageContentHandler);
		return newInstance(proxy);
	}
}
