package com.smart.hospital.common.mq.factory;

import com.smart.hospital.common.mq.handler.MessageContentHandler;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.util.StringUtils;


/**
 * RabbitClient注册器
 */
public class RabbitClientRegister implements BeanDefinitionRegistryPostProcessor, ApplicationContextAware {

	private RabbitTemplate rabbitTemplate;

	private String rabbitTemplateBeanName;

	private String basePackage;

	private ApplicationContext applicationContext;

	private MessageContentHandler messageContentHandler;

	public RabbitClientRegister(RabbitTemplate rabbitTemplate) {
		this.rabbitTemplate = rabbitTemplate;
	}

	public RabbitClientRegister() {
	}

	@Override
	public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
		RabbitClientScanner scanner = new RabbitClientScanner(registry);
		if (this.rabbitTemplate != null) {
			scanner.setRabbitTemplate(this.rabbitTemplate);
		}
		if (this.rabbitTemplateBeanName != null) {
			scanner.setRabbitTemplateBeanName(this.rabbitTemplateBeanName);
		}
		scanner.setMessageContentHandler(this.messageContentHandler);
		scanner.setApplicationContext(applicationContext);
		scanner.registerFilters();
		scanner.scan(StringUtils.tokenizeToStringArray(this.basePackage, ConfigurableApplicationContext.CONFIG_LOCATION_DELIMITERS));
	}

	@Override
	public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
		// do nothing
	}

	@Override
	public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
		this.applicationContext = applicationContext;
	}

	public void setBasePackage(String basePackage) {
		this.basePackage = basePackage;
	}

	public void setRabbitTemplate(RabbitTemplate rabbitTemplate) {
		this.rabbitTemplate = rabbitTemplate;
	}

	public void setRabbitTemplateBeanName(String rabbitTemplateBeanName) {
		this.rabbitTemplateBeanName = rabbitTemplateBeanName;
	}

	public void setMessageContentHandler(MessageContentHandler messageContentHandler) {
		this.messageContentHandler = messageContentHandler;
	}
}
