package com.smart.hospital.common.mq.factory;

import com.smart.hospital.common.mq.handler.MessageContentHandler;
import lombok.extern.slf4j.Slf4j;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;


@Slf4j
public abstract class RabbitTemplateSupport implements InitializingBean {

	protected RabbitTemplate rabbitTemplate;

	protected ApplicationContext applicationContext;

	protected MessageContentHandler messageContentHandler;

	private boolean externalTemplate = false;

	public void setRabbitTemplate(RabbitTemplate rabbitTemplate) {
		if (!this.externalTemplate) {
			this.rabbitTemplate = rabbitTemplate;
			externalTemplate = true;
		}
	}

	public void setApplicationContext(ApplicationContext applicationContext) {
		this.applicationContext = applicationContext;
	}

	public void setMessageContentHandler(MessageContentHandler messageContentHandler) {
		this.messageContentHandler = messageContentHandler;
	}

	@Override
	public void afterPropertiesSet() throws Exception {
		checkRabbitTemplate();
	}

	private void checkRabbitTemplate() {
		if (this.rabbitTemplate == null && this.applicationContext != null) {
			this.rabbitTemplate = this.applicationContext.getBean(RabbitTemplate.class);
			this.externalTemplate = true;
		}
		if (this.rabbitTemplate == null) {
			log.warn("Property 'rabbitTemplate' are required");
		}

	}

}
