package com.smart.hospital.common.mq.handler;

import org.springframework.amqp.core.Message;

/**
 * 消息从Exchange路由到Queue失败处理器
 */
public interface ReturnCallbackHandler {

	/**
	 * Returned message callback.
	 *
	 * @param message    the returned message.
	 * @param replyCode  the reply code.
	 * @param replyText  the reply text.
	 * @param exchange   the exchange.
	 * @param routingKey the routing key.
	 * @return
	 */
	Object returnCallback(Message message, int replyCode, String replyText, String exchange, String routingKey);
}
