package com.smart.hospital.common.pay;

import com.smart.hospital.common.pay.annotation.ClientScan;
import com.smart.hospital.common.pay.parser.DefaultPayAnnotationParser;
import com.smart.hospital.common.pay.parser.PayAnnotationParser;
import com.smart.hospital.common.pay.prop.WxPayV3Properties;
import com.smart.hospital.common.pay.source.AnnotationPayAttributeSource;
import com.smart.hospital.common.pay.source.PayAttributeSource;
import com.smart.hospital.common.pay.strategy.PayStrategy;
import com.smart.hospital.common.pay.strategy.PayStrategyManager;
import com.smart.hospital.common.pay.strategy.StrategyPropertiesCustomizer;
import com.smart.hospital.common.pay.strategy.builder.HandlerFactoryBuilder;
import com.smart.hospital.common.pay.strategy.builder.PayHandlerFactoryBuilder;
import com.smart.hospital.common.pay.strategy.handler.WxCertV3StrategyHandler;
import com.smart.hospital.common.pay.strategy.handler.WxJsapiV3StrategyHandler;
import com.smart.hospital.common.pay.strategy.handler.StrategyHandler;
import com.smart.hospital.common.pay.strategy.handler.WxRefundStrategyHandler;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.lang.Nullable;

import java.util.List;

/**
 * 支付自动配置类
 */
@Order
@Configuration
@EnableConfigurationProperties({WxPayV3Properties.class})
@ClientScan(basePackages = {"com.smart.hospital.common.pay.client"})
public class PayAutoConfiguration {

//	@Bean
	// 使用该种方法会导致过早得实例化，从而导致配置文件WxPayV3Properties注入得属性都为空
//	public static PayClientBeanConfigurer payClientBeanConfigurer(PayAttributeSource payAttributeSource, PayStrategy payStrategyManager) {
//		PayClientBeanConfigurer configurer = new PayClientBeanConfigurer();
//		configurer.setPayAttributeSource(payAttributeSource);
//		configurer.setPayStrategyManager(payStrategyManager);
//		configurer.setBasePackage("com.smart.hospital.common.pay.client");
//		return configurer;
//	}

	@Bean
	public PayAttributeSource annotationPayAttributeSource(ObjectProvider<List<PayAnnotationParser>> objectProvider) {
		return new AnnotationPayAttributeSource(objectProvider.getIfAvailable());
	}

	@Bean
	public PayAnnotationParser defaultPayAnnotationParser() {
		return new DefaultPayAnnotationParser();
	}

	@Bean
	@ConditionalOnMissingBean
	public HandlerFactoryBuilder payHandlerFactoryBuilder(ObjectProvider<List<StrategyHandler>> objectProvider) {
		return new PayHandlerFactoryBuilder(objectProvider.getIfAvailable());
	}

	@Bean
	@ConditionalOnMissingBean
	public PayStrategy payStrategyManager(HandlerFactoryBuilder payHandlerFactoryBuilder) {
		PayStrategyManager strategyManager = new PayStrategyManager();
		strategyManager.setFactoryBuilder(payHandlerFactoryBuilder);
		return strategyManager;
	}

	@Bean
	@ConditionalOnMissingClass
	public StrategyPropertiesCustomizer strategyPropertiesCustomizer(@Nullable WxPayV3Properties wxPayV3Properties, @Nullable List<StrategyHandler> handlers) {
		return new StrategyPropertiesCustomizer(wxPayV3Properties, handlers);
	}

	@Bean
	public StrategyHandler wxJsapiV3StrategyHandler() {
		return new WxJsapiV3StrategyHandler();
	}

	@Bean
	public StrategyHandler wxCertV3StrategyHandler() {
		return new WxCertV3StrategyHandler();
	}

	@Bean
	public StrategyHandler wxRefundStrategyHandler() {
		return new WxRefundStrategyHandler();
	}

}
