package com.smart.hospital.common.pay.annotation;

import com.smart.hospital.common.pay.constant.Version;
import com.smart.hospital.common.pay.enums.*;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * 微信支付
 */
@Target(ElementType.METHOD)
@Retention(RetentionPolicy.RUNTIME)
public @interface WX {

	/**
	 * 支付方式
	 *
	 * @return
	 */
	PaymentMethod payment() default PaymentMethod.WX_JSAPI;

	/**
	 * 商户平台模式
	 *
	 * @return
	 */
	PayModel model() default PayModel.BUSINESS_MODEL;

	/**
	 * 版本
	 *
	 * @return
	 */
	String version() default Version.WX_V2;

	/**
	 * 请求路径前缀
	 *
	 * @return
	 */
	Domain prefix() default Domain.CHINA;

	/**
	 * 请求路径后缀
	 *
	 * @return
	 */
	Uri suffix();

	/**
	 * 请求方式
	 *
	 * @return
	 */
	RequestMethod method() default RequestMethod.POST;
}
