package com.smart.hospital.common.pay.config;

import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.GenericBeanDefinition;

import java.util.Objects;
import java.util.Set;

@Slf4j
public class PayClientRegistryScanner extends AbstractClientRegistryScanner {

	public PayClientRegistryScanner(BeanDefinitionRegistry registry) {
		super(registry);
	}

	@Override
	protected void processBeanDefinitions(Set<BeanDefinitionHolder> beanDefinitions) {
		GenericBeanDefinition definition;
		for (BeanDefinitionHolder holder : beanDefinitions) {
			definition = (GenericBeanDefinition) holder.getBeanDefinition();
			log.info("Creating FactoryBean with name '" + holder.getBeanName() + "' and '" + definition.getBeanClassName() + "' clientInterface");
			// 构造器注入
			definition.getConstructorArgumentValues().addGenericArgumentValue(Objects.requireNonNull(definition.getBeanClassName()));
			// 属性注入
			definition.getPropertyValues().add("payAttributeSource", getPayAttributeSource());
			definition.getPropertyValues().add("payStrategy", getPayStrategy());
			// 设置FactoryBean类型
			definition.setBeanClass(getFactoryBean().getClass());
			definition.setPrimary(true);
			definition.setAutowireMode(AbstractBeanDefinition.AUTOWIRE_BY_TYPE);
		}
	}
}
