package com.smart.hospital.common.pay.enums;

/**
 * 支付方式枚举
 */
public enum PaymentMethod {

	WX_JSAPI("WX_JSAPI", "小程序/公众号支付"),
	WX_APP("WX_APP", "APP支付"),
	WX_NATIVE("WX_NATIVE", "二维码支付"),
	WX_MICRO("WX_MICRO", "付款码支付"),
	WX_REFUND("WX_REFUND", "退款"),
	WX_CERT("WX_CERT", "微信获取平台证书"),

	ALI_FACE("ALI_FACE", "当面付"),
	ALI_APP("ALI_APP", "App支付"),
	ALI_WEB("ALI_WEB", "手机网站支付"),
	ALI_WAP("ALI_WAP", "电脑网站支付"),
	ALI_SWIPING("ALI_SWIPING", "刷脸付"),
	;

	private String name;

	private String describe;

	PaymentMethod(String name, String describe) {
		this.name = name;
		this.describe = describe;
	}

	public String getDescribe() {
		return describe;
	}

	public void setDescribe(String describe) {
		this.describe = describe;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}
}
