package com.smart.hospital.common.pay.factory;

import org.springframework.beans.factory.FactoryBean;

public class PayFactoryBean<T> extends PayFactoryBeanSupport implements FactoryBean<T> {

	private Class<T> clientInterface;

	public PayFactoryBean() {
	}

	public PayFactoryBean(Class<T> clientInterface) {
		this.clientInterface = clientInterface;
	}

	@Override
	public T getObject() throws Exception {
		return registerClient();
	}

	@Override
	public Class<?> getObjectType() {
		return this.clientInterface;
	}

	@Override
	public boolean isSingleton() {
		return true;
	}

	private T registerClient() {
		PayProxyFactory<T> payProxyFactory = new PayProxyFactory<>(this.clientInterface);
		return payProxyFactory.newInstance(getPayAttributeSource(), getPayStrategy());
	}
}
