package com.smart.hospital.common.pay.parser;

import com.smart.hospital.common.pay.annotation.ALI;
import com.smart.hospital.common.pay.annotation.UNION;
import com.smart.hospital.common.pay.annotation.WX;
import com.smart.hospital.common.pay.source.PayAttribute;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotationAttributes;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;

public abstract class AbstractPayAnnotationParser implements PayAnnotationParser {

	/**
	 * 注解中的参数信息
	 */
	protected final String PAYMENT_METHOD_NAME = "payment";
	protected final String VERSION_NAME = "version";
	protected final String URL_PREFIX_NAME = "prefix";
	protected final String URL_SUFFIX_NAME = "suffix";
	protected final String REQUEST_METHOD_NAME = "method";
	protected final String MODEL_NAME = "model";

	/**
	 * 所有的所注解类型
	 */
	private static final Class<? extends Annotation>[] PAY_ANNOTATION_CLASSES = new Class[]{WX.class, ALI.class, UNION.class};

	@Override
	public PayAttribute parsePayAnnotation(AnnotatedElement element) {
		for (Class<? extends Annotation> clazz : PAY_ANNOTATION_CLASSES) {
			AnnotationAttributes attributes = AnnotatedElementUtils.findMergedAnnotationAttributes(element, clazz, false, false);
			if (attributes != null) {
				return parsePayAnnotation(attributes);
			}
		}
		return null;
	}

	protected abstract PayAttribute parsePayAnnotation(AnnotationAttributes attributes);
}
