package com.smart.hospital.common.pay.source;

import com.smart.hospital.common.pay.enums.*;
import org.springframework.http.HttpMethod;

public class DefaultPayAttribute implements PayAttribute {

	private final PaymentMethod paymentMethod;

	private final PayModel payModel;

	private final String version;

	private final Domain prefix;

	private final Uri suffix;

	private final RequestMethod requestMethod;

	public DefaultPayAttribute(PaymentMethod paymentMethod, String version, Domain prefix, Uri suffix, RequestMethod requestMethod, PayModel payModel) {
		this.paymentMethod = paymentMethod;
		this.version = version;
		this.prefix = prefix;
		this.suffix = suffix;
		this.requestMethod = requestMethod;
		this.payModel = payModel;
	}

	@Override
	public PaymentMethod getPayment() {
		return paymentMethod;
	}

	@Override
	public String getVersion() {
		return this.version;
	}

	@Override
	public Domain getPrefix() {
		return this.prefix;
	}

	@Override
	public Uri getSuffix() {
		return this.suffix;
	}

	@Override
	public RequestMethod getRequestMethod() {
		return this.requestMethod;
	}

	@Override
	public PayModel getModel() {
		return this.payModel;
	}

	@Override
	public String toString() {
		return "DefaultPayAttribute{" +
				"paymentMethod=" + paymentMethod +
				", payModel=" + payModel +
				", version='" + version + '\'' +
				", prefix=" + prefix +
				", suffix=" + suffix +
				", requestMethod=" + requestMethod +
				'}';
	}
}
