package com.smart.hospital.common.pay.source;

import com.smart.hospital.common.pay.enums.*;

/**
 * 支付注解属性
 */
public interface PayAttribute {

	/**
	 * 获取支付方式
	 *
	 * @return
	 */
	PaymentMethod getPayment();

	/**
	 * 商户平台模式
	 *
	 * @return
	 */
	PayModel getModel();

	/**
	 * 获取支付版本号
	 *
	 * @return
	 */
	String getVersion();

	/**
	 * 获取调用的url路径前缀
	 *
	 * @return
	 */
	Domain getPrefix();

	/**
	 * 获取url后缀
	 *
	 * @return
	 */
	Uri getSuffix();

	/**
	 * 获取调用方式(post/get)
	 *
	 * @return
	 */
	RequestMethod getRequestMethod();
}
