package com.smart.hospital.common.pay.strategy;

import com.smart.hospital.common.pay.prop.WxPayV3Properties;
import com.smart.hospital.common.pay.strategy.handler.StrategyHandler;
import org.springframework.beans.factory.InitializingBean;

import java.util.List;

public class StrategyPropertiesCustomizer implements InitializingBean {

	private WxPayV3Properties wxPayV3Properties;

	private List<StrategyHandler> handlers;

	public StrategyPropertiesCustomizer(WxPayV3Properties wxPayV3Properties, List<StrategyHandler> handlers) {
		this.wxPayV3Properties = wxPayV3Properties;
		this.handlers = handlers;
	}

	@Override
	public void afterPropertiesSet() throws Exception {
		if (handlers != null && !handlers.isEmpty()) {
			for (StrategyHandler handler : handlers) {
				handler.setProperties(wxPayV3Properties);
			}
		}
	}
}
