package com.smart.hospital.common.pay.strategy.handler;

import com.smart.hospital.common.pay.prop.WxPayV3Properties;
import com.smart.hospital.common.pay.source.PayAttribute;

import java.lang.reflect.Method;

/**
 * 策略处理器
 */
public interface StrategyHandler {

	/**
	 * 适用
	 *
	 * @param attribute
	 * @return
	 */
	boolean apply(PayAttribute attribute);

	/**
	 * 执行前
	 *
	 * @param attribute
	 * @param clientInterface
	 * @param method
	 * @param args
	 * @return
	 */
	default Object beforeExecute(PayAttribute attribute, Class<?> clientInterface, Method method, Object[] args) {
		return null;
	}

	/**
	 * 执行接口调用
	 *
	 * @param params
	 * @return
	 */
	Object execute(PayAttribute attribute, Object... params) throws Exception;

	/**
	 * 执行后
	 *
	 * @param attribute
	 * @param clientInterface
	 * @param method
	 * @param args
	 * @param result
	 * @return
	 */
	default Object afterExecute(PayAttribute attribute, Class<?> clientInterface, Method method, Object[] args, Object result) {
		return null;
	}

	default Object exception(PayAttribute attribute, Class<?> clientInterface, Method method, Object[] args, Exception ex) {
		return null;
	}

	/**
	 * 设置参数
	 */
	void setProperties(WxPayV3Properties wxPayV3Properties);
}
