

package com.smart.hospital.common.security.annotation;

import com.smart.hospital.common.security.component.SmartResourceServerAutoConfiguration;
import com.smart.hospital.common.security.component.SmartSecurityBeanDefinitionRegistrar;
import org.springframework.context.annotation.Import;
import org.springframework.security.config.annotation.method.configuration.EnableGlobalMethodSecurity;
import org.springframework.security.oauth2.config.annotation.web.configuration.EnableResourceServer;

import java.lang.annotation.*;

/**
 * @author giaogiao
 * @date 2018/11/10
 * <p>
 * 资源服务注解
 */
@Documented
@Inherited
@EnableResourceServer
@Target({ElementType.TYPE})
@Retention(RetentionPolicy.RUNTIME)
@EnableGlobalMethodSecurity(prePostEnabled = true)
@Import({SmartResourceServerAutoConfiguration.class, SmartSecurityBeanDefinitionRegistrar.class})
public @interface EnableSmartResourceServer {

}
