

package com.smart.hospital.common.security.exception;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.smart.hospital.common.security.component.SmartAuth2ExceptionSerializer;
import lombok.Getter;
import org.springframework.security.oauth2.common.exceptions.OAuth2Exception;

/**
 * @author giaogiao
 * @date 2018/7/8
 * 自定义OAuth2Exception
 */
@JsonSerialize(using = SmartAuth2ExceptionSerializer.class)
public class SmartAuth2Exception extends OAuth2Exception {
	@Getter
	private String errorCode;

	public SmartAuth2Exception(String msg) {
		super(msg);
	}

	public SmartAuth2Exception(String msg, String errorCode) {
		super(msg);
		this.errorCode = errorCode;
	}
}
