package com.smart.hospital.register.api.entity;

import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
/**
 * <p>
 * 
 * </p>
 *
 * @author yuzhiqiang
 * @since 2022-03-23
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("gh_registered")
@ApiModel(value="GhRegistered对象", description="")
public class GhRegistered extends Model<GhRegistered> {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    @ApiModelProperty(value = "用户ID(即操作人的用户ID)")
    private Long userId;

    @ApiModelProperty(value = "医院ID")
    private Long hospitalId;

    @ApiModelProperty(value = "医院名称")
    private String hospitalName;

    @ApiModelProperty(value = "科室ID")
    private String deptId;

    @ApiModelProperty(value = "科室名称")
    private String deptName;

    @ApiModelProperty(value = "医生ID")
    private String doctorId;

    @ApiModelProperty(value = "医生名称")
    private String doctorName;

    @ApiModelProperty(value = "医生排班ID")
    private String schemaId;

    @ApiModelProperty(value = "医生门诊分时ID")
    private String poolId;

    @ApiModelProperty(value = "主要职责(主任医师，主治医生)")
    private String major;

    @ApiModelProperty(value = "1:普通号，2:专家号")
    private String clinicType;

    @ApiModelProperty(value = " 就诊人ID")
    private String patientId;

    @ApiModelProperty(value = "就诊人姓名")
    private String patientName;

    @ApiModelProperty(value = "就诊人手机号")
    private String phone;

    @ApiModelProperty(value = "就诊卡号")
    private String cardNo;

    @ApiModelProperty(value = "就诊时间")
    private String appointmentTime;

    @ApiModelProperty(value = "挂号时间")
    private LocalDateTime registeredTime;

    @ApiModelProperty(value = "就诊序号 14:30-14:40")
    private String appointmentOrder;

    @ApiModelProperty(value = "就诊费用")
    private BigDecimal medicalExpenses;

    @ApiModelProperty(value = "支付方式(1：微信，2：支付宝，3：银联)")
    private Integer payType;

    @ApiModelProperty(value = "支付状态(0:待支付，1:支付中，2:已支付)")
    private Integer payStatus;

    @ApiModelProperty(value = "支付时间")
    private LocalDateTime payTime;

    @ApiModelProperty(value = "HIS系统中的订单编号")
    private String hisOrderNo;

    @ApiModelProperty(value = "HIS系统就诊序号")
    private String serialNo;

    @ApiModelProperty(value = "HIS系统就诊地址")
    private String location;

    @ApiModelProperty(value = "HIS系统号票编号")
    private String tiketNo;

    @ApiModelProperty(value = "该条数据的状态(1:正常，0:删除，2：超时，3：退号)")
    private Integer status;

    @ApiModelProperty(value = "HIS返回的门诊号")
    private String clincNo;

    @ApiModelProperty(value = "1:上午，2:下午，3:晚上")
    private Integer timeFrame;

    @ApiModelProperty(value = "微信系统生成的订单号")
    private String wxOrderNo;

    @ApiModelProperty(value = "1:正常挂号，2:补号记录")
    private Integer fillType;

    @ApiModelProperty(value = "0：不能评价，1：能评价，2：已评价")
    private Integer canEval;

    @ApiModelProperty(value = "医院来源编号")
    private String resourceId;

    private Integer beforeClinicInfoId;

    @ApiModelProperty(value = "操作者")
    private String operator;

    @ApiModelProperty(value = "退款时间")
    private String refundTime;

    @ApiModelProperty(value = "退款备注")
    private String remark;

    @Override
    protected Serializable pkVal() {
        return null;
    }

}
