package com.smart.hospital.admin.api.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
/**
 * <p>
 * 
 * </p>
 *
 * @author yuzhiqiang
 * @since 2022-03-23
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("yy_hospital_info")
@ApiModel(value="YyHospitalInfo对象", description="")
public class YyHospitalInfo extends Model<YyHospitalInfo> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "医院ID")
    @TableId(value = "hospital_id", type = IdType.AUTO)
    private Integer hospitalId;

    @ApiModelProperty(value = "医院编码")
    private String hospitalCode;

    @ApiModelProperty(value = "医院名称")
    private String hospitalName;

    @ApiModelProperty(value = "医院logo")
    private String hospitalLogo;

    @ApiModelProperty(value = "级别：一级，二级等")
    private Integer hospitalLevel;

    @ApiModelProperty(value = "等级：甲，乙，丙")
    private Integer hospitalGrade;

    @ApiModelProperty(value = "类型：(1市属,2基层医疗,3村卫生院,4民营)")
    private Integer hospitalType;

    @ApiModelProperty(value = "医院特色科室")
    private String hospitalSpecial;

    private String hospitalDesc;

    private String hospitalAddress;

    @ApiModelProperty(value = "医院联系电话")
    private String hospitalPhone;

    @ApiModelProperty(value = "经度")
    private String hospitalLon;

    @ApiModelProperty(value = "纬度")
    private String hospitalLat;

    @ApiModelProperty(value = "医院主页")
    private String homePage;

    @ApiModelProperty(value = "上午开始时间")
    private String amStartTime;

    @ApiModelProperty(value = "上午结束时间")
    private String amEndTime;

    @ApiModelProperty(value = "下午开始时间")
    private String pmStartTime;

    @ApiModelProperty(value = "下午结束时间")
    private String pmEndTime;

    private LocalDateTime createTime;

    @ApiModelProperty(value = "1：删除")
    private String delFlag;

    @ApiModelProperty(value = "过期时间")
    private LocalDateTime expireTime;

    @ApiModelProperty(value = "状态:0启用1禁用")
    private Integer status;

    @Override
    protected Serializable pkVal() {
        return null;
    }

}
