

package com.smart.hospital.admin.api.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.time.LocalDateTime;


/**
 * 图形验证码
 *
 * @author giaogiao
 * @date 2017-12-18
 */
@Data
@ApiModel(value =  "图形验证码")
public class ImageCode implements Serializable {
	/**
	 * 随机数
	 */
	@ApiModelProperty(value = "随机数")
	private String code;
	/**
	 * 验证码过期时间
	 */
	@ApiModelProperty(value = "验证码过期时间")
	private LocalDateTime expireTime;
	/**
	 * 验证码图片
	 */
	@ApiModelProperty(value = "验证码图片")
	private BufferedImage image;

	public ImageCode(BufferedImage image, String sRand, int defaultImageExpire) {
		this.image = image;
		this.code = sRand;
		this.expireTime = LocalDateTime.now().plusSeconds(defaultImageExpire);
	}
}
