

package com.smart.hospital.admin.api.vo;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;

/**
 * @author: Lucky
 * @date: 2019/04/28
 * <p>
 * 公共参数
 */
@Data
@ApiModel(value = "公共参数展示对象")
@EqualsAndHashCode(callSuper = false)
@JsonIgnoreProperties(ignoreUnknown = true)
public class ParamVo implements Serializable {

    private static final long serialVersionUID = 1L;
    /**
     * 公共参数键
     */
    @ApiModelProperty(value = "公共参数键")
    private String publicKey;
    /**
     * 公共参数值
     */
    @ApiModelProperty(value = "公共参数值")
    private String publicValue;
    /**
     * 公共参数名
     */
    @ApiModelProperty(value = "公共参数名称")
    private String publicName;
}