package com.smart.hospital.admin.controller.upms;

import cn.hutool.core.util.StrUtil;
import com.smart.hospital.common.core.util.R;
import com.smart.hospital.common.pay.client.PayClient;
import com.smart.hospital.common.pay.model.*;
import com.smart.hospital.common.pay.util.PayKit;
import com.smart.hospital.common.security.annotation.Inner;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.List;

@Slf4j
@Api(value = "支付测试", tags = {"支付测试"})
@RestController
@AllArgsConstructor
@RequestMapping("/pay")
public class PayController {

	@Autowired
	PayClient payClient;

	@Inner(value = false)
	@ApiOperation(value = "支付")
	@GetMapping(value = "/do")
	public R pay() {
		return R.ok(payClient.wxJsapiPay(new WxUnifiedOrderModel()
				.setDescription("支付测试")
				.setOut_trade_no(PayKit.generateStr())
				.setAttach("挂号支付测试")
				.setAmount(new Amount().setTotal(1))
				.setPayer(new Payer().setOpenid("oRkq_4okxD_JqZxcElrifwJe5jEs"))));
	}

	@Inner(value = false)
	@ApiOperation(value = "退款")
	@GetMapping(value = "/refund")
	public R refund(@RequestParam(required = false) String transactionId, @RequestParam(required = false) String outTradeNo) {

		String outRefundNo = PayKit.generateStr();
		log.info("商户退款单号: {}", outRefundNo);

		List<WxRefundGoodsDetail> list = new ArrayList<>();
		WxRefundGoodsDetail refundGoodsDetail = new WxRefundGoodsDetail()
				.setMerchant_goods_id("123")
				.setGoods_name("测试退款")
				.setUnit_price(1)
				.setRefund_amount(1)
				.setRefund_quantity(1);
		list.add(refundGoodsDetail);

		WxRefundModel refundModel = new WxRefundModel()
				.setOut_refund_no(outRefundNo)
				.setReason("测试退款")
				.setAmount(new WxRefundAmount().setRefund(1).setTotal(1).setCurrency("CNY"))
				.setGoods_detail(list);

		if (StrUtil.isNotEmpty(transactionId)) {
			refundModel.setTransaction_id(transactionId);
		}
		if (StrUtil.isNotEmpty(outTradeNo)) {
			refundModel.setOut_trade_no(outTradeNo);
		}
		return R.ok(payClient.wxRefund(refundModel));
	}

	@Inner(value = false)
	@ApiOperation(value = "获取平台证书")
	@GetMapping(value = "/cert")
	public R cert() {
		return R.ok(payClient.wxPlatformCert());
	}
}
