package com.smart.hospital.admin.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.service.IService;
import com.smart.hospital.admin.api.dto.hospital.HospitalQueryDTO;
import com.smart.hospital.admin.api.entity.YyHospitalInfo;
import com.smart.hospital.admin.api.vo.hospital.HospitalDetailVO;
import com.smart.hospital.admin.api.vo.hospital.HospitalListVO;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * <p>
 * 服务类
 * </p>
 *
 * @author yuzhiqiang
 * @since 2022-03-23
 */
public interface IYyHospitalInfoService extends IService<YyHospitalInfo> {

	/**
	 * 分页查询医院列表信息
	 *
	 * @param hospitalQuery
	 * @return
	 */
	IPage<HospitalListVO> getHospitalInfoList(HospitalQueryDTO hospitalQuery);

	/**
	 * 获取医院详情
	 *
	 * @param hospitalId
	 * @return
	 */
	HospitalDetailVO getDetailByHospitalId(Long hospitalId);
}
