package com.smart.hospital.admin.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.smart.hospital.admin.api.constant.factory.PageFactory;
import com.smart.hospital.admin.api.dto.hospital.HospitalQueryDTO;
import com.smart.hospital.admin.api.entity.YyHospitalInfo;
import com.smart.hospital.admin.api.vo.hospital.HospitalDetailVO;
import com.smart.hospital.admin.api.vo.hospital.HospitalListVO;
import com.smart.hospital.admin.convert.ModelConvertMapper;
import com.smart.hospital.admin.mapper.YyHospitalInfoMapper;
import com.smart.hospital.admin.service.IYyHospitalInfoService;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Service;

/**
 * <p>
 * 服务实现类
 * </p>
 *
 * @author yuzhiqiang
 * @since 2022-03-23
 */
@Service
@AllArgsConstructor
public class YyHospitalInfoServiceImpl extends ServiceImpl<YyHospitalInfoMapper, YyHospitalInfo> implements IYyHospitalInfoService {

	private final ModelConvertMapper convertMapper;

	@Override
	public IPage<HospitalListVO> getHospitalInfoList(HospitalQueryDTO hospitalQuery) {
		return this.baseMapper.getHospitalInfoList(new PageFactory<HospitalListVO>().defaultPage(), hospitalQuery);
	}

	@Override
	public HospitalDetailVO getDetailByHospitalId(Long hospitalId) {
		YyHospitalInfo hospitalInfo = this.getById(hospitalId);
		HospitalDetailVO detail = convertMapper.convertHospitalDetail(hospitalInfo);
		detail.setAm(hospitalInfo.getAmStartTime() + "-" + hospitalInfo.getAmEndTime());
		detail.setPm(hospitalInfo.getPmStartTime() + "-" + hospitalInfo.getPmEndTime());
		return detail;
	}
}
