# Generated by Django 3.1.2 on 2021-02-10 01:42

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Api',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=50, verbose_name='接口名称')),
                ('http_method', models.CharField(choices=[('POST', 'POST'), ('GET', 'GET'), ('PUT', 'PUT'), ('DELETE', 'DELETE')], max_length=50, verbose_name='请求方式')),
                ('path', models.CharField(max_length=1024, verbose_name='接口地址')),
                ('headers', models.TextField(blank=True, null=True, verbose_name='请求头')),
                ('request_type', models.CharField(choices=[('json', 'json'), ('form-data', 'form-data')], default='form-data', max_length=20, verbose_name='请求类型')),
                ('data', models.TextField(blank=True, null=True, verbose_name='提交的数据')),
                ('description', models.CharField(blank=True, max_length=1024, null=True, verbose_name='描述')),
                ('expect_code', models.CharField(choices=[('200', '200'), ('201', '201'), ('202', '202'), ('203', '203'), ('204', '204'), ('301', '301'), ('302', '302'), ('400', '400'), ('401', '401'), ('403', '403'), ('404', '404'), ('405', '405'), ('406', '406'), ('407', '407'), ('408', '408'), ('500', '500'), ('502', '502')], default=200, max_length=10, verbose_name='期望返回的code')),
                ('expect_content', models.CharField(blank=True, max_length=200, null=True, verbose_name='期望返回的内容')),
                ('create_time', models.DateTimeField(auto_now=True, verbose_name='运行的时间')),
            ],
            options={
                'verbose_name': '接口信息',
                'verbose_name_plural': '接口信息',
                'db_table': 'fusion_api',
            },
        ),
        migrations.CreateModel(
            name='Project',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=50, verbose_name='项目名称')),
                ('type', models.CharField(choices=[['web', 'web'], ['app', 'app']], max_length=50, verbose_name='项目类型')),
                ('description', models.CharField(blank=True, max_length=1024, null=True, verbose_name='描述')),
                ('create_time', models.DateTimeField(auto_now=True, verbose_name='更新时间')),
                ('found_time', models.DateTimeField(auto_now_add=True, verbose_name='创建时间')),
            ],
            options={
                'verbose_name': '项目表',
                'verbose_name_plural': '项目表',
                'db_table': 'fusion_project',
            },
        ),
        migrations.CreateModel(
            name='RunApiRecord',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('url', models.CharField(max_length=200, verbose_name='请求的url')),
                ('http_method', models.CharField(choices=[('POST', 'POST'), ('GET', 'GET'), ('PUT', 'PUT'), ('DELETE', 'DELETE')], max_length=10, verbose_name='请求方式')),
                ('data', models.TextField(null=True, verbose_name='提交的数据')),
                ('headers', models.TextField(null=True, verbose_name='提交的header')),
                ('create_time', models.DateTimeField(auto_now=True, verbose_name='运行的时间')),
                ('return_code', models.CharField(max_length=10, verbose_name='返回的code')),
                ('return_content', models.TextField(null=True, verbose_name='返回的内容')),
                ('return_cookies', models.TextField(null=True, verbose_name='返回的cookies')),
                ('return_headers', models.TextField(null=True, verbose_name='返回的headers')),
                ('assert_result', models.CharField(max_length=10, null=True, verbose_name='断言结果')),
                ('api', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='apiTest.api', verbose_name='关联的API')),
            ],
            options={
                'verbose_name': 'api运行记录',
                'verbose_name_plural': 'api运行记录',
                'db_table': 'fusion_run_api_record',
                'ordering': ['-create_time'],
            },
        ),
        migrations.CreateModel(
            name='Host',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=50, verbose_name='名称')),
                ('host', models.CharField(max_length=1024, verbose_name='Host地址')),
                ('description', models.CharField(blank=True, max_length=1024, null=True, verbose_name='描述')),
                ('create_time', models.DateTimeField(auto_now=True, verbose_name='更新时间')),
                ('found_time', models.DateTimeField(auto_now_add=True, verbose_name='创建时间')),
                ('project', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='host_list', to='apiTest.project', verbose_name='所属项目')),
            ],
            options={
                'verbose_name': 'host域名',
                'verbose_name_plural': 'host域名',
                'db_table': 'fusion_host',
            },
        ),
        migrations.CreateModel(
            name='ApiArgumentExtract',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=100, null=True, verbose_name='参数名字')),
                ('origin', models.CharField(choices=[('HEADER', 'HEADER'), ('BODY', 'BODY'), ('COOKIE', 'COOKIE')], max_length=20, null=True, verbose_name='参数来源')),
                ('format', models.CharField(max_length=100, null=True, verbose_name='参数获取的格式')),
                ('api', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='argumentExtract', to='apiTest.api', verbose_name='用例API')),
            ],
            options={
                'verbose_name': '用例API的参数提取',
                'verbose_name_plural': '用例API的参数提取',
                'db_table': 'fusion_api_argument_extract',
            },
        ),
        migrations.CreateModel(
            name='ApiArgument',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=100, null=True, verbose_name='参数名字')),
                ('value', models.CharField(max_length=100, null=True, verbose_name='参数的值')),
                ('api', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='arguments', to='apiTest.api', verbose_name='用例')),
            ],
            options={
                'verbose_name': 'api的参数',
                'verbose_name_plural': 'api的参数',
                'db_table': 'fusion_api_argument',
            },
        ),
        migrations.AddField(
            model_name='api',
            name='host',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='apiTest.host', verbose_name='host'),
        ),
        migrations.AddField(
            model_name='api',
            name='project',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='api_list', to='apiTest.project', verbose_name='项目'),
        ),
    ]
