
# CHAT-QUERY

[en](./README.md)

> Chat-Query 是一个基于元数据模型和 AI 技术，通过自然语言实现数据查询。

## 演示

> [在线预览](https://query.fusiontech.cn/)

> [demo gif](https://cdn.glitch.me/fd139a45-4a65-41b6-9634-41617ab20cdc/%E6%BC%94%E7%A4%BA.gif?v=1686907695067)

+ **功能特点🐂：**

	- 支持导入 DDL、DBML 和数据库逆向解析，AI 自动生成业务模型。
	- 提供业务模型的基本 CRUD 功能、AI 智能分析，支持模型导出为 DDL、DBML 以及与数据库同步。
	- 结合模型和 AI 实现自然语言数据查询，可添加至查询列表并通过 API 调用。
	- BI分析、Function 调用、react代码沙箱、支持导入npm包。

## 应用场景🎬

+ 从低代码到零代码开发。
+ 非业务人员快速进行数据分析。
+ 更多应用场景待探索...

## 部署
+ docker compose

	```shell
	NEXT_PUBLIC_OPEN_AI_API_KEY="sk-..." docker-compose up
	```
+ chat-query和chat-query-backend都是支持docker构建和提供docker镜像.

## 开发环境设置

> 👏 欢迎参与 Chat-Query 的建设。

+ 后端：

  ```js
		pnpm install
		pnpm start:dev
	```
	- 在 .env 文件中添加

	```shell
		#openai
		OPEN_AI_API_KEY='sk-...'
		MODEL_NAME="gpt-3.5-turbo-16k-0613"
		BASE_URL='https://open-ai-xyy.deno.dev/v1'
		# database
		DB_HOST="139.198.179.193"
		DB_PORT=32094
	```

+ 前端

	```js
		pnpm install
		pnpm dev
	```
	- 在 .env 文件中添加

	```shell
		NEXT_PUBLIC_OPEN_AI_API_KEY='sk-...'
		OPENAI_PROXY_URL="https://open-ai-xyy.deno.dev/"
		NEXT_PUBLIC_BACKEND_URL="http://localhost:3001/"
	```

## 系统架构

![架构](https://cdn.glitch.global/fd139a45-4a65-41b6-9634-41617ab20cdc/%E6%97%A0%E6%A0%87%E9%A2%98-2023-05-31-1202%20(1).png?v=1686908252244)
