import { ChatMessage } from './../../components/AITool/index';
import APi, { backendApi } from '.';
import { get, isArray, max, min, pick } from 'lodash';
import { Options } from 'redaxios';
import OpenAI from './openAI';

export interface View {
    type: 'schema' | 'table';
    name?: string;
}

const privateConfig: Options & {
    timeout: number;
} = {
    timeout: 1000 * 60,
};

function extractCodeBlocks(markdownText: string, lang = null) {
    const codeBlockRegex = /```(\w+)?\n([\s\S]*?)```/g;
    const codeBlocks = [];

    let match;
    while ((match = codeBlockRegex.exec(markdownText)) !== null) {
        if (lang === null || match[1] === lang) {
            codeBlocks.push(match[2]);
        }
    }

    return codeBlocks;
}
export default class getView {
    static getViewComponent(params: { props: Record<string, any>; need: string }) {
        return new Promise((res, rej) => {
            OpenAI.request(
                [
                    {
                        role: 'user',
                        content: `我正在使用react-live作为一个实时编辑和编译React组件的工具。请根据我的需求，输出一段能在react-live运行的代码，只需要导出默认组件，不用挂载dom。可用的作用域如下：
{
  data,
  import: {
    'styled-components':{
      '描述':'A css in js Framework,Visual primitives for the component age. Use the best bits of ES6 and CSS to style your apps without stress'
    },
    'echarts':{
      '描述'：'Apache ECharts is a powerful, interactive charting and data visualization library for browser.',
      '用法': "import echarts from 'echarts';"
    },
    'echarts-for-react':{
      '描述'：'Apache ECharts is a powerful, interactive charting and data visualization library for browser.',
      '用法': "import React from 'react';
import ReactECharts from 'echarts-for-react';  // or var ReactECharts = require('echarts-for-react');

<ReactECharts
  option={this.getOption()}
  notMerge={true}
  lazyUpdate={true}
  theme={"theme_name"}
  onChartReady={this.onChartReadyCallback}
  onEvents={EventsDict}
  opts={}
/>"
    },
  },
}

其中import可供导入的库,除此之外不能使用其它第三方库。 key为包名，value 是包的描述。其它每个属性将作为单独全局变量，变量名为属性名。请确保默认导出的组件接受null作为参数，并将传入props取自模块全局作用域变量data（const props = data）,全局变量变量data会自动注入,请不要进行声明。例如：

export default App() {
const props = data;
...
}
`,
                    },
                    {
                        role: 'assistant',
                        content: `好的我明白啦,请问你的业务是什么?`,
                    },
                    {
                        role: 'user',
                        content: `这是我传入的props:${JSON.stringify(
                            params.props.slice(0, min([params.props.length, 4]))
                        )}。${params.need}`,
                    },
                ],
                (responseText: string, cancel?: boolean) => {
                    let code;
                    try {
                        code = JSON.parse(get(JSON.parse(responseText), 'arguments')).reactCode;
                    } catch (e) {}
                    res({
                        data: {
                            code: code,
                        },
                    });
                },
                undefined,
                undefined,
                [
                    {
                        name: 'runReactCode',
                        description: '作为一个实时编译React组件代码的函数。',
                        parameters: {
                            type: 'object',
                            properties: {
                                reactCode: {
                                    type: 'string',
                                    description: '输出一段能在react-live运行的代码',
                                },
                            },
                            required: ['sql', 'queryName', 'queryDescription', 'simulation'],
                        },
                    },
                ],
                undefined,
                { name: 'runReactCode' },
                false
            );
        });
        // return backendApi.post(
        //     '/openAi/api/reactLive',
        //     isArray(params.props)
        //         ? {
        //               ...params,
        //               props: params.props.slice(0, min([params.props.length, 4])),
        //           }
        //         : params,
        //     privateConfig
        // );
    }
    static getViewFunction(params: { data: Record<string, any>; need: string }) {
        return backendApi.post(
            '/openAi/api/code',
            isArray(params.data)
                ? {
                      ...params,
                      data: params.data.slice(0, min([params.data.length, 4])),
                  }
                : params,
            privateConfig
        );
    }
    static checkChatResult(messageList: ChatMessage[]) {
        return backendApi.post('/openAi/api/checkQuery', { messageList }, privateConfig);
    }
}
