import {
    Button,
    Input,
    Comment,
    Avatar,
    Skeleton,
    Form,
    Modal,
    Spin,
    Notification,
    AutoComplete,
    Alert,
    Switch,
} from '@arco-design/web-react';
import { useTranslation } from 'react-i18next';
import MessageItem from './MessageItem';

import { debounce, filter, get, map } from 'lodash';
import React, {
    ReactElement,
    ReactNode,
    useCallback,
    useEffect,
    useMemo,
    useReducer,
    useRef,
    useState,
} from 'react';
import { IconRecord, IconRobot, IconSend, IconSwap, IconVoice } from '@arco-design/web-react/icon';
import OpenAI from '@/client/api/openAI';
import getView from '@/client/api/getView';

let useSpeechToText: any;
export interface ChatMessage {
    role: 'system' | 'user' | 'assistant';
    content: string;
}

const getQuestion = (question: string) => `${question}`;

type AIProps = {
    context?: any;
    messageList: any[];
    setMessageList: (value: any[]) => any;
    startView?: number;
    renderMessageItem?: any;
    doneFx?: (message: string) => any;
    simpleMode?: string | true;
    simpleModeVisible?: boolean;
    setSimpleModeVisible?: (flag?: boolean) => any;
    welcome?: ReactElement | string;
    quickTip?:
        | { value: string | string[]; name: string | string[]; [key: string]: any }[]
        | string[];
    searchFlag?: RegExp;
    inputProps?: Record<string, any>;
    SendButton?: ({ inputRef }: { inputRef: any }) => JSX.Element;
    noHistory?: boolean;
    functions?: any[];
    stream?: boolean;
    function_call?: any;
    isCheck?: boolean;
};

export function AIWrapper({
    context,
    messageList,
    setMessageList,
    startView = 0,
    renderMessageItem,
    doneFx,
    simpleMode,
    simpleModeVisible = false,
    setSimpleModeVisible = () => {},
    welcome = '',
    quickTip = [],
    searchFlag = /^\//,
    inputProps = {},
    SendButton,
    noHistory,
    functions,
    function_call,
    stream,
    isCheck = false,
}: AIProps) {
    const input = useRef<any>();
    const scrollContainer = useRef<any>();
    const [loading, setLoading] = useState(false);

    // 发送信息事件和成功的事件
    const [currentAssistantMessage, setCurrentAssistantMessage] = useState('');
    const [thinking, setThinking] = useState(false); //假的加载
    const [check, setCheck] = useState<string | boolean>(false); // 检查需求
    const [checkOpen, setIsCheck] = useState(isCheck);
    const handleButtonClickSuccess = useEffect(() => {
        if (!currentAssistantMessage || loading) {
            return;
        }
        setMessageList([
            ...messageList,

            {
                role: 'assistant',
                content: currentAssistantMessage,
            },
        ]);
        setCurrentAssistantMessage('');
        toView();
        // return clearContext;
    }, [currentAssistantMessage, loading]);

    const closeRef = useRef<any>();
    const close = () => {
        if (closeRef.current) {
            closeRef.current();
        }
    };
    const toView = useCallback(
        debounce(
            () => {
                scrollContainer &&
                    scrollContainer?.current?.scrollIntoView({
                        behavior: 'smooth',
                        block: 'end',
                    });
            },
            50,
            { maxWait: 500 }
        ),
        []
    );
    const requestMessageList = useMemo(() => {
        if (functions) {
            return messageList.map(v => {
                if (v.role === 'assistant') {
                    let fn;
                    try {
                        fn = JSON.parse(get(v, 'content'));
                    } catch (e) {
                        fn = '';
                    }
                    return {
                        ...v,
                        content: functions && fn ? '' : get(v, 'content'),
                        function_call: functions && fn ? fn : undefined,
                    };
                }
                return v;
            });
        }
        return messageList;
    }, [messageList]);

    const handleButtonClick = useCallback(
        (message?: string, callBack?: (m: string) => void) => {
            const inputRef = input.current?.dom;
            const inputValue = message || inputRef.value;
            if (!inputValue) {
                return;
            }
            let initMessageList = [
                ...requestMessageList,
                {
                    role: 'user',
                    content: inputValue,
                },
            ];
            setMessageList([
                ...messageList,
                {
                    role: 'user',
                    content: inputValue,
                },
            ]);
            // @ts-ignore
            setRecordValue('');
            setLoading(true);
            toView();
            let checked = checkOpen ? false : true;
            const request = () => {
                OpenAI.request(
                    noHistory
                        ? initMessageList.slice(0, startView).concat({
                              role: 'user',
                              content: inputValue,
                          })
                        : initMessageList,

                    (currentAssistantMessageStr, cancel) => {
                        setThinking(true);
                        setCheck(true);
                        const done = () => {
                            setCheck(false);
                            setLoading(false);
                            setTimeout(toView, 100);
                            setCurrentAssistantMessage(currentAssistantMessageStr);
                            callBack && callBack(currentAssistantMessageStr);
                            doneFx && doneFx(currentAssistantMessageStr);
                        };
                        checked || cancel
                            ? done()
                            : getView
                                  .checkChatResult([
                                      ...initMessageList,
                                      {
                                          role: 'user',
                                          content: inputValue,
                                      },
                                      {
                                          role: 'assistant',
                                          function_call: functions
                                              ? JSON.parse(currentAssistantMessageStr)
                                              : undefined,
                                          content: functions ? '' : currentAssistantMessageStr,
                                      },
                                  ])
                                  .then((v: any) => {
                                      const { answerMeetsRequirements, why } = get(
                                          v,
                                          'data.output',
                                          {}
                                      );
                                      checked = true;
                                      setThinking(false);
                                      setTimeout(toView, 100);
                                      if (answerMeetsRequirements) {
                                          done();
                                      } else {
                                          setCheck(why);
                                          initMessageList.push(
                                              {
                                                  role: 'assistant',
                                                  function_call: functions
                                                      ? JSON.parse(currentAssistantMessageStr)
                                                      : undefined,
                                                  content: functions
                                                      ? ''
                                                      : currentAssistantMessageStr,
                                              },
                                              {
                                                  role: 'user',
                                                  content: `错误！！！！,你的回答不符合的需求,你的回答存在以下问题:\n${why}。\n请改正这些问题并重新输出。`,
                                              }
                                          );
                                          request();
                                      }
                                  });
                    },
                    val => {
                        setCurrentAssistantMessage(val);
                        toView();
                    },
                    () => {
                        Notification.error({
                            title: 'No Response',
                            content: undefined,
                        });
                    },
                    functions,
                    closeRef,
                    function_call,
                    stream || !functions
                );
            };
            request();
        },
        [
            loading,
            messageList,
            currentAssistantMessage,
            setCurrentAssistantMessage,
            input,
            handleButtonClickSuccess,
            scrollContainer,
            setCheck,
            checkOpen,
        ]
    );

    // 清除功能
    const clear = () => {
        const inputRef = get(input, 'current.dom');
        if (inputRef) {
            setRecordValue('');
            setMessageList(messageList.slice(0, startView));
            setCurrentAssistantMessage('');
        }
    };

    // 用户信息
    const [Niche, setNiche] = useState('you');
    const user: {
        photoId?: string;
    } = {};
    const userIcon = user?.photoId ? (
        `/api/v1/assets/${user?.photoId}`
    ) : (
        <Avatar
            size={32}
            className="shadow-lg m-[1px] bg-gradient-to-tr from-orange-300  to-[var(--pc)]"
        >
            {Niche}
        </Avatar>
    );

    // 上下文传递
    useEffect(() => {
        context && context({ clear });
    }, [context]);

    // 快捷功能
    const [isSearching, setSearching] = useState<string | false>(false);
    const quickTipData = useMemo(() => {
        const el = input.current?.dom;
        if (isSearching && el) {
            return filter(quickTip, ({ value }: { value: string }) => {
                if (el) {
                    return value.indexOf(isSearching.replace(searchFlag, '').trim()) !== -1;
                }
            });
        }

        return [];
    }, [isSearching, quickTip, input]);

    //动画
    const { t } = useTranslation('actions');
    const animaeString = t(
        !quickTip.length
            ? 'Please input your question'
            : 'Starting with "/", retrieve frequently asked questions'
    );
    const [placeholder, setPlaceholder] = useState('');
    let timer = useRef<any>();
    useEffect(() => {
        timer.current && clearTimeout(timer.current);
        if (simpleModeVisible) {
            let f = 1;
            let perStr = '';
            const start = () => {
                if (perStr.length === 0) {
                    f = 1;
                } else if (perStr === animaeString) {
                    f = -1;
                }
                perStr = animaeString.slice(0, perStr.length + f);
                setPlaceholder(perStr);
                timer.current = setTimeout(() => {
                    start();
                }, 300);
            };
            start();
        }
        return () => clearTimeout(timer.current);
    }, [timer, simpleModeVisible, animaeString]);

    //语音功能
    const { error, interimResult, isRecording, results, startSpeechToText, stopSpeechToText } =
        useSpeechToText({
            continuous: true,
            useLegacyResults: false,
            speechRecognitionProperties: {
                interimResults: true, // Allows for displaying real-time speech results
                continuous: true,
            },
        });

    const [beforeRecordValue, setBeforeRecordValue] = useState('');
    const [recordValue, setRecordValue] = useState('');
    useEffect(() => {
        if (!isRecording) {
            const el = input.current?.dom;
            console.log(recordValue);
            if (el) el.value = recordValue || '';
        }
    }, [isRecording, recordValue]);

    useEffect(() => {
        if (interimResult) {
            const el = input.current?.dom;
            if (el) el.value = beforeRecordValue + (interimResult || '');
        }
    }, [interimResult, beforeRecordValue]);

    const inputValue = input.current?.dom.value || '';
    const RenderMessageItem = renderMessageItem || MessageItem;

    const inputNode = (
        <Input
            ref={input}
            placeholder={simpleModeVisible ? placeholder + '│' : animaeString}
            allowClear={!isRecording}
            style={{ width: 650 }}
            height={56}
            className="overflow-hidden  shadow-md simple-mode  shadow-cyan-500/30"
            autoFocus
            onPressEnter={() => !SendButton && handleButtonClick()}
            value={inputValue}
            onChange={value => {
                console.log(value, 'value');
                const el = input.current?.dom;
                if (el) {
                    el.value = value;
                }
                setRecordValue(value);
            }}
            onClear={() => {
                const el = input.current?.dom;
                if (el) {
                    el.value = '';
                }
                setRecordValue('');
                setBeforeRecordValue('');
            }}
            suffix={
                <>
                    <Button
                        shape="circle"
                        icon={isRecording ? <IconRecord className="animate-ping" /> : <IconVoice />}
                        type="text"
                        className="mx-[10px] text-[15px]"
                        size="mini"
                        onClick={() => {
                            if (isRecording) {
                                setRecordValue(input.current?.dom.value || '');
                                stopSpeechToText();
                            } else {
                                setBeforeRecordValue(input.current?.dom.value || '');
                                startSpeechToText();
                            }
                        }}
                    />
                    {SendButton ? (
                        <SendButton inputRef={input} />
                    ) : (
                        <Button
                            disabled={loading || isRecording}
                            shape="circle"
                            icon={<IconSend />}
                            size="mini"
                            type="primary"
                            onClick={() => handleButtonClick()}
                        />
                    )}
                </>
            }
            {...inputProps}
        />
    );

    const detail = useMemo<ReactNode>(() => {
        if (check) {
            return (
                <div className="my-[20px]">
                    <div
                        className={`flex gap-3 p-4 box-border  shadow mx-[5px] rounded transition-colors mt-[20px] font-hm ${'bg-[var(--white-bg)] text-[#333]'}`}
                    >
                        <Form style={{ width: '100%' }} autoComplete="off">
                            <div className="py-[10px] pb-[30px] text-[20px] justify-between flex">
                                {t('Reviewing and checking if query aligns with requirements')}
                                <span>
                                    <IconSwap />
                                </span>
                            </div>
                            {check !== true ? (
                                <Alert
                                    content={t('Requirements and answers do not align')}
                                    type={'warning'}
                                    className="my-[20px]"
                                />
                            ) : null}
                            <pre
                                className="break-before-all"
                                style={{
                                    whiteSpace: 'break-spaces',
                                }}
                            >
                                {check}
                            </pre>
                        </Form>
                    </div>
                </div>
            );
        }
        if (currentAssistantMessage) {
            return (
                <div className="my-[20px]">
                    <div
                        className={`flex gap-3 p-4 box-border  shadow mx-[5px] rounded transition-colors mt-[20px] font-hm ${'bg-[var(--white-bg)] text-[#333]'}`}
                    >
                        <Form style={{ width: '100%' }} autoComplete="off">
                            <div className="py-[10px] pb-[30px] text-[20px] justify-between flex">
                                {t('A query has been generated for you')}
                                <span>
                                    <IconSwap />
                                </span>
                            </div>
                            <pre
                                className="break-before-all"
                                style={{
                                    whiteSpace: 'break-spaces',
                                }}
                            >
                                {currentAssistantMessage}
                            </pre>
                        </Form>
                    </div>
                </div>
            );
        } else {
            return (
                <div className="my-[20px]">
                    <Skeleton
                        animation
                        text={{
                            rows: 5,
                            width: ['100%', '100%', '100%', '100%', 400],
                        }}
                    />
                </div>
            );
        }
    }, [currentAssistantMessage, check]);
    console.log(currentAssistantMessage, 'currentAssistantMessage');

    if (simpleMode) {
        if (simpleMode === 'input') {
            return inputNode;
        }
        return simpleModeVisible ? (
            <Modal
                footer={null}
                title={null}
                visible={simpleModeVisible}
                closeIcon={null}
                maskClosable
                // onOk={() => setVisible(false)}
                onCancel={() => setSimpleModeVisible(false)}
                maskStyle={{
                    background: 'rgb(94 171 165 / 0.1)',
                    backdropFilter: ' blur(4px) hue-rotate(90deg) opacity(0.5)',
                    // backdropFilter: ' hue-rotate(90deg)',
                }}
                wrapClassName="!flex justify-center items-center"
                autoFocus={true}
                modalRender={() => {
                    return !loading ? (
                        <div className="translate-y-[200px]">{inputNode}</div>
                    ) : (
                        <Spin dot />
                    );
                }}
            />
        ) : null;
    }

    return (
        <div className="w-full p-[15px] rounded">
            <div
                className="overflow-y-auto overflow-x-hidden mr-[-10px] pr-[10px] pb-[10px]"
                style={{
                    height: 'calc(100vh - 257px)',
                }}
            >
                {
                    <Comment
                        align="right"
                        author={t('assistant')}
                        avatar={
                            <IconRobot
                                style={{ fontSize: '32px', color: 'rgb(var(--primary-6))' }}
                            />
                        }
                        content={
                            welcome ? (
                                welcome
                            ) : (
                                <MessageItem
                                    message={t(
                                        'Hello! I an CHAT QUERY ai, please describe your business!'
                                    )}
                                    role={'assistant'}
                                />
                            )
                        }
                        key="message"
                    />
                }
                {map(messageList.slice(startView), (message, index) => (
                    <Comment
                        align="right"
                        author={message.role === 'user' ? Niche : t('assistant')}
                        avatar={
                            message.role === 'user' ? (
                                userIcon
                            ) : (
                                <IconRobot
                                    style={{ fontSize: '32px', color: 'rgb(var(--primary-6))' }}
                                />
                            )
                        }
                        content={
                            <RenderMessageItem
                                message={message.content}
                                role={message.role}
                                rawRender={MessageItem}
                            />
                        }
                        key={index}
                    />
                ))}
                {loading && (
                    <Comment
                        align="right"
                        author={t('assistant')}
                        avatar={
                            <IconRobot
                                style={{ fontSize: '32px', color: 'rgb(var(--primary-6))' }}
                            />
                        }
                        content={detail}
                    />
                )}
                <div ref={scrollContainer} />
            </div>
            {loading ? (
                <>
                    <div className="animate-bounce">
                        <div className="h-12 my-4 flex items-center justify-center rounded-sm  text-[30px] font-bold gradient-text">
                            {check
                                ? check !== true
                                    ? `${t('Requirements and answers do not align, rethinking')}...`
                                    : `${t('Reviewing requirements and answers')}...`
                                : `${t('Analyzing requirements')}...`}
                        </div>
                    </div>
                    <Button className="shadow" onClick={close} size="mini" shape="round">
                        {t('Cancel')}
                    </Button>
                </>
            ) : (
                <Comment
                    className="items-stretch !mt-[5px] pt-[15px] mx-[-15px] px-[15px] shadow-t"
                    actions={[
                        <span className="flex items-center">
                            <span className="mr-[10px] text-[12px]">自动检查</span>
                            <Switch
                                type="line"
                                size="small"
                                checked={checkOpen}
                                onChange={value => {
                                    setIsCheck(value);
                                }}
                            />
                        </span>,
                        <Button
                            key="0"
                            onClick={clear}
                            type="secondary"
                            className="shadow rounded"
                            disabled={loading || isRecording}
                        >
                            {t('reset')}
                        </Button>,
                        <Button
                            className="shadow rounded"
                            disabled={loading || isRecording}
                            key="1"
                            onClick={() => handleButtonClick()}
                            type="primary"
                        >
                            {t('send')}
                        </Button>,
                        <Button
                            key="2"
                            onClick={() => {
                                if (isRecording) {
                                    setRecordValue(input.current?.dom.value || '');
                                    stopSpeechToText();
                                } else {
                                    setBeforeRecordValue(input.current?.dom.value || '');
                                    startSpeechToText();
                                }
                            }}
                            type="secondary"
                            shape="circle"
                        >
                            {isRecording ? (
                                <IconRecord className="animate-ping text-[var(--pc)]" />
                            ) : (
                                <IconVoice className="text-[var(--pc)]" />
                            )}
                        </Button>,
                    ]}
                    align="right"
                    avatar={userIcon}
                    content={
                        <div>
                            <AutoComplete
                                data={quickTipData}
                                triggerElement={<Input.TextArea autoComplete="off" id="input" />}
                                autoFocus
                                disabled={loading}
                                placeholder={animaeString}
                                ref={input}
                                value={inputValue}
                                onChange={value => {
                                    const el = input.current?.dom;
                                    if (el) el.value = value || '';
                                    setRecordValue(value);
                                }}
                                onPressEnter={e => {
                                    if (
                                        e.key === 'Enter' &&
                                        !e?.nativeEvent.isComposing &&
                                        !isSearching
                                    ) {
                                        console.log(e.ctrlKey);
                                        if (e.ctrlKey) {
                                            const el = input.current?.dom;
                                            if (el) {
                                                el.value = `${input.current?.dom?.value}\n`;
                                            }
                                        } else {
                                            handleButtonClick();
                                        }
                                    }
                                }}
                                filterOption={false}
                                onSearch={value => {
                                    if (searchFlag.test(value)) {
                                        setSearching(value);
                                    } else {
                                        setSearching(false);
                                    }
                                }}
                                triggerProps={{
                                    position: 'top',
                                    popupAlign: {
                                        top: 16,
                                    },
                                    className: 'w-full',
                                    // popupVisible: true,
                                }}
                                onSelect={(value: string) => {
                                    const el = input.current?.dom;
                                    if (el) {
                                        el.value = value;
                                    }
                                    setSearching(false);
                                    requestAnimationFrame(() => {
                                        input.current?.focus();
                                    });
                                }}
                            />
                        </div>
                    }
                />
            )}
        </div>
    );
}

export default function Ai(props: AIProps) {
    const [initNun, refresh] = useReducer(state => ++state, 0);
    useEffect(() => {
        if (window && !useSpeechToText) {
            import('react-hook-speech-to-text').then(({ default: fx }) => {
                useSpeechToText = fx;
                refresh();
            });
        }
    }, []);
    return initNun || useSpeechToText ? <AIWrapper {...props} /> : null;
}
