import { Cell } from '@antv/x6';
import { ReactShapeConfig } from '@antv/x6-react-shape';
import { type } from 'os';
import React from 'react';

interface DagContext {
  activeCell?: Cell;
}

export enum DagActions {
  'CHANGE_ACTIVE_CELL',
}

let count = 1;

type dispatchType<T> = (type: T) => any;

type ExtractProps<T> = T extends React.ComponentType<infer P> ? P : never;
type NodeProps = ReactShapeConfig['component'];
export type CustomProps = ExtractProps<NodeProps>;

export type DagContextType = React.Context<
  DagContext & {
    dispatch: (actions: {
      type: DagActions;
      payload: (typeof actions)['type'] extends DagActions.CHANGE_ACTIVE_CELL ? Cell : never;
    }) => any;
  }
>;

export default function getDagContext() {
  const DagContext = React.createContext<DagContext>({});
  DagContext.displayName = 'DagContext' + count;
  const { Provider, Consumer, displayName } = DagContext;
  console.log(count, 'countcount');
  count++;
  return { Provider, Consumer, displayName, DagContext };
}
