export const QUERY_FUNCTION = [
    {
        name: 'saveExecuteSqlInfo',
        description:
            'Unique and mandatory execution (no other functions can be executed), storing the key information required to execute this requirement',
        parameters: {
            type: 'object',
            properties: {
                simulation: {
                    type: 'boolean',
                    description:
                        'This requirement needs you to generate simulated data, with true or false options.',
                },
                sql: {
                    type: 'string',
                    description: `If the user's requirements include generating simulated data, you should generate this data first and ensure that it is included in the SQL output.,The SQL statement required to execute the operation must adhere to standard syntax.  Additionally, the data inserted must comply with the existing table structure.`,
                },
                variablesArr: {
                    type: 'array',
                    description:
                        'Execute SQL statement containing an array of variables and their descriptions: If the requirement specifies simulated data, the parameter should be null.',
                    items: {
                        type: 'object',
                        properties: {
                            variable: {
                                type: 'string',
                                description:
                                    'The name of the variables.The information that needs to be filled in by the user should be treated as variables, and the variable names must be enclosed between $ signs.',
                            },
                            varDescription: {
                                type: 'string',
                                description: 'The description of the variable',
                            },
                        },
                        required: ['variable', 'varDescription'],
                    },
                },
                queryName: {
                    type: 'string',
                    description: 'The name of the query',
                },
                queryDescription: {
                    type: 'string',
                    description: 'The description of the query',
                },
            },
            required: ['sql', 'queryName', 'queryDescription', 'simulation'],
        },
    },
];
