import i18n from 'i18next';
import LanguageDetector from 'i18next-browser-languagedetector';
import { initReactI18next } from 'react-i18next';
import zhCommon from './locales/zh/common.json';
import { map } from 'lodash';

i18n.use(LanguageDetector)
    .use(initReactI18next)
    .init({
        // we init with resources
        resources: {
            zh: {
                translations: {
                    ...zhCommon,
                },
                modelList: {
                    'Sample data generated success': '示例数据生成成功',
                    'Example already exists or name conflicts': '示例已经存在或名称冲突',
                    'Create a new ERD model': '创建新的ERD模型',
                    'Create an ERD model from an example': '从示例中创建ERD模型',
                    'Are you sure to delete this graph?': '确定要删除此模型吗？',
                    'Edit Query': '编辑查询',
                    'Edit Model': '编辑模型',
                    Delete: '删除',
                    'Queries List': '查询列表',
                },
                ListNav: {
                    'Create Query': '创建查询',
                    'Import Database': '数据库导入',
                    'Import DBML': '导入DBML',
                    'Import DDL': '导入DDL',
                    'Import excel': '导入excel',
                    'Create from Blank': '从空白新建',
                    'New Model': '新建模型',
                    'Import Example': '导入示例',
                    'Data Query Based on Data Model and AI': '基于数据模型和AI的数据查询',
                    'Created by AI': '由 AI 新建',
                    'AI was unable to understand your input, please further clarify your input.':
                        'AI未能理解您的输入, 请进一步明确您的输入。',
                },
                nav: {
                    'Import DBML': '导入 DBML',
                    'Import DDL': '导入 DDL',
                    'Import excel': '导入excel',
                    'Apply Select Version': '应用所选版本',
                    'Exit Logs View': '退出日志视图',
                    Save: '保存',
                    'Add Table': '添加表',
                    'Import Table': '导入表',
                    'New Table': '新建表',
                    Clear: '清空',
                    Export: '导出',
                    Logs: '日志',
                    Yes: '是',
                    No: '否',
                    'Successfully added the following database tables': '已经成功新增以下数据表',
                    'According to your business needs, a new database model has been generated for you.':
                        '根据您提供的业务需求，已为您生成新的数据模型。',
                    'Generation failed, please modify the requirements and try again.':
                        '生成失败，请修改需求重试。',
                    'Table field information': '表字段信息',

                    'AI createTable': 'AI建表',
                    'Are you sure you want to delete all the tables?': '你是否确定删除所有表?',
                },
                graph: {
                    'Edit Table': '编辑表格',
                    Commit: '提交',
                    'Add field': '添加字段',
                    Yes: '是',
                    No: '否',
                    'Please enter table name': '请输入表格名称',
                    'Delete table': '删除表格',
                    'Are you sure you want to delete this table?': '确定要删除此表格吗？',
                    'have same name table': '存在同名表格',
                    'Add field after': '在后面添加字段',
                    'Please enter field name': '请输入字段名称',
                    'Please choose field type': '请选择字段类型',
                    Comment: '备注',
                    'Move up': '上移',
                    'Move down': '下移',
                    'Remove field': '删除字段',
                    'Table Name': '表名',
                    'Table Comment': '表注释',
                    Default: '默认值',
                    Type: '类型',
                    Name: '名称',
                    Type1: '字段类型',
                    Name1: '字段名称',
                    Cancel: '取消',
                    Edit: '编辑',
                    Field: '字段',
                    'Are you sure delete this field?': '您确定要删除这个字段吗？',
                },
                linkModal: {
                    'Change relation': '更改关系',
                    'Delete Path': '删除路径',
                    startPoint: '起始点',
                    endpoint: '结束点',
                },
                fieldForm: [
                    'Cancel',
                    'Please enter field name',
                    'Please choose field type',
                    'have same name field',
                    'Commit',
                    'Edit',
                    'Field',
                    'default',
                    'Default',
                    'Comment',
                    'Type',
                ],
                ContextMenu: {
                    'Add New Table': '添加新表',
                    'Import Table': '导入表',
                    'Save Change': '保存更改',
                    'Export Database': '导出数据库',
                },
                tablesNav: {
                    'input table name': '输入表名称',
                    Tables: '表格',
                },
                table: {
                    Theme: '主题',
                    Clear: '清除',
                    Yes: '是',
                    No: '否',
                    Save: '保存',
                    'Do you want to save your changes before leaving?':
                        '你本次修改未保存，是否保存本次修改？',
                    'Are you sure you want to delete this table?': '您确定要删除此表吗？',
                    'Please Enter Comment': '请输入评论',
                    Commit: '提交',
                    'No Comment': '无评论',
                    'Are you sure you want to delete this field?': '您确定要删除此字段吗？',
                    Cancel: '取消',
                    Comment: '评论',
                    'Yes, restore them': '是的，恢复它们',
                    'No, ignore them': '不，忽略它们',
                    'Unsaved changes': '未保存的更改',
                    'You have some unsaved changes after last version, do you want to restore them? Once you press the no button, the unsaved changes will be cleaned immediately. You can’t undo this action.':
                        '您在上一个版本之后有一些未保存的更改，您想要恢复它们吗？一旦您按下“否”按钮，未保存的更改将立即被清除。您无法撤消此操作。',
                },
                actions: {
                    assistant: 'AI助手',
                    input: '输入',
                    'Please input your question': '请输入你的问题',
                    'Starting with "/", retrieve frequently asked questions':
                        '以“/”开头，快速获取常见问题',
                    'A query has been generated for you': '已为你生成查询',
                    run: '运行',
                    'Add into queries List': '添加到查询列表',
                    reset: '重置',
                    send: '发送',
                    'Select model to create': '选择模型新建',
                    'Execution succeeded': '执行成功',
                    'Analyzing requirements': '分析需求中',
                    'Creating query': '创建查询中',
                    'Query generation in progress': '正在生成查询',
                    'Reviewing and checking if query aligns with requirements':
                        '正在审核查询是否满足需求',
                    'Hello! I an CHAT QUERY ai, please describe your business!':
                        '您好！我是 CHAT QUERY AI，请描述您的业务！',
                    'Connection Name': '连接名称',
                    Connection: '连接',
                    'Create a new database in the data source': '在数据源中创建新的数据库',
                    'Database Information': '数据库信息',
                    'New Database Name': '新建数据库名称',
                    'Query Information': '查询信息',
                    'Model Description': '模型描述',
                    'In AI Analysis Model': 'AI 分析模型中',
                    'Confirm deletion': '确定删除',
                    _QUERY_: '_查询_',
                    'Failed to generate query': '生成查询失败',
                    'Error in query': '错误查询',
                    Cancel: '取消',
                    'Cannot generate executable query from the requirement description, please continue to describe the requirement!':
                        '从需求描述中不能为您生成可执行的查询，请继续描述的需求!',
                    'Requirements and answers do not align': '需求和回答没有对齐',
                    'Requirements and answers do not align, rethinking':
                        '需求和回答没有对齐，重新思考中',
                    'Reviewing requirements and answers': '正在审查需求和回答',
                },
                modal: {
                    Import: '导入',
                    Close: '关闭',
                    'Import ERD Data Model': '导入ERD数据模型',
                    'Export ERD Data Model': '导出ERD数据模型',
                    'Copy Success': '复制成功',
                    'Copy Failed': '复制失败',
                    Copy: '复制',
                    'Import Failed': '导入失败',
                    'Test Connection': '测试连接',
                    Clear: '清空',
                    'Please Input Database Password': '请输入数据库密码',
                    'Please Input Database Name': '请输入数据库名称',
                    Password: '密码',
                    'Database Type': '数据库类型',
                    'Please Input Username': '请输入用户名',
                    Account: '账号',
                    'Please Select': '请选择',
                    'Connection Information': '连接信息',
                    'Please Input IP': '请输入IP',
                    'Please Input Port': '请输入端口',
                    'Connection Failed': '连接失败',
                    'Connection Succeeded': '连接成功',
                },
                queriesList: {
                    'Data Preview': '数据预览',
                    'Parameter check failed': '执行失败，请检查参数',
                    RUN: '运行',
                    'Deletion succeeded': '删除成功',
                    'Query Description': '查询描述',
                    'No description needed': '无需描述',
                    'Parameter Description': '参数描述',
                    'No parameters needed': '无需参数',
                    'Request Address': '请求地址',
                    'Execution Details': '执行详情',
                    'Edit Query': '编辑查询',
                    'Queries List': '查询列表',
                },
                actionForm: {
                    'please enter query name': '请输入查询名称',
                    name: '名称',
                },
                chatView: {
                    'custom display': '自定义显示',
                    'Function for processing data': '处理数据的函数',
                    'Add component': '添加组件',
                    'Code generation in progress, please wait...': '代码生成中，请稍后...',
                    'Data processing functions': '数据处理函数',
                    'Comment + Tab to generate function': '以 `//` 开头的注释 + Tab 生成函数',
                    'Execute function name': '执行函数名称',
                    'No function description available': '暂无函数描述',
                    Run: '运行',
                    'Execution successful': '执行成功',
                    'Loading dependencies': '正在加载依赖',
                    'Loading completed': '加载完成',
                },
            },
        },
        fallbackLng: 'en',
        debug: true,

        // have a common namespace used around the full app
        ns: ['translations', 'modelList'],
        defaultNS: 'translations',

        keySeparator: false, // we use content as keys

        interpolation: {
            escapeValue: false,
        },
    });

export default i18n;
